/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.graphics.RectF;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.CropWindowMoveHandler;

final class CropWindowHandler {
    private final RectF mEdges = new RectF();
    private final RectF mGetEdges = new RectF();
    private float mMinCropWindowWidth;
    private float mMinCropWindowHeight;
    private float mMinCropResultWidth;
    private float mMinCropResultHeight;
    private float mMaxCropResultWidth;
    private float mMaxCropResultHeight;
    private float mScaleFactorWidth = 1.0f;
    private float mScaleFactorHeight = 1.0f;

    CropWindowHandler() {
    }

    public RectF getRect() {
        this.mGetEdges.set(this.mEdges);
        return this.mGetEdges;
    }

    public float getMinCropWidth() {
        return Math.max(this.mMinCropWindowWidth, this.mMinCropResultWidth / this.mScaleFactorWidth);
    }

    public float getMinCropHeight() {
        return Math.max(this.mMinCropWindowHeight, this.mMinCropResultHeight / this.mScaleFactorHeight);
    }

    public float getMaxCropWidth() {
        return this.mMaxCropResultWidth / this.mScaleFactorWidth;
    }

    public float getMaxCropHeight() {
        return this.mMaxCropResultHeight / this.mScaleFactorHeight;
    }

    public float getScaleFactorWidth() {
        return this.mScaleFactorWidth;
    }

    public float getScaleFactorHeight() {
        return this.mScaleFactorHeight;
    }

    public void setScaleFactor(float scaleFactorWidth, float scaleFactorHeight) {
        this.mScaleFactorWidth = scaleFactorWidth;
        this.mScaleFactorHeight = scaleFactorHeight;
    }

    public void setInitialAttributeValues(float minCropWindowWidth, float minCropWindowHeight, float minCropResultWidth, float minCropResultHeight, float maxCropResultWidth, float maxCropResultHeight) {
        if (minCropWindowWidth < 0.0f) {
            throw new IllegalArgumentException("Cannot set min crop window width value to a number < 0 ");
        }
        this.mMinCropWindowWidth = minCropWindowWidth;
        if (minCropWindowHeight < 0.0f) {
            throw new IllegalArgumentException("Cannot set min crop window height value to a number < 0 ");
        }
        this.mMinCropWindowHeight = minCropWindowHeight;
        if (minCropResultWidth < 0.0f) {
            throw new IllegalArgumentException("Cannot set min crop result width value to a number < 0 ");
        }
        this.mMinCropResultWidth = minCropResultWidth;
        if (minCropResultHeight < 0.0f) {
            throw new IllegalArgumentException("Cannot set min crop result height value to a number < 0 ");
        }
        this.mMinCropResultHeight = minCropResultHeight;
        if (maxCropResultWidth < minCropResultWidth) {
            throw new IllegalArgumentException("Cannot set max crop result width to smaller value than min crop result width");
        }
        this.mMaxCropResultWidth = maxCropResultWidth;
        if (maxCropResultHeight < minCropResultHeight) {
            throw new IllegalArgumentException("Cannot set max crop result height to smaller value than min crop result height");
        }
        this.mMaxCropResultHeight = maxCropResultHeight;
    }

    public void setRect(RectF rect) {
        this.mEdges.set(rect);
    }

    public boolean showGuidelines() {
        return !(this.mEdges.width() < 100.0f) && !(this.mEdges.height() < 100.0f);
    }

    public CropWindowMoveHandler getMoveHandler(float x, float y, float targetRadius, CropImageView.CropShape cropShape) {
        CropWindowMoveHandler.Type type = cropShape == CropImageView.CropShape.OVAL ? this.getOvalPressedMoveType(x, y) : this.getRectanglePressedMoveType(x, y, targetRadius);
        return type != null ? new CropWindowMoveHandler(type, this, x, y) : null;
    }

    private CropWindowMoveHandler.Type getRectanglePressedMoveType(float x, float y, float targetRadius) {
        CropWindowMoveHandler.Type moveType = null;
        if (CropWindowHandler.isInCornerTargetZone(x, y, this.mEdges.left, this.mEdges.top, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.TOP_LEFT;
        } else if (CropWindowHandler.isInCornerTargetZone(x, y, this.mEdges.right, this.mEdges.top, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.TOP_RIGHT;
        } else if (CropWindowHandler.isInCornerTargetZone(x, y, this.mEdges.left, this.mEdges.bottom, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.BOTTOM_LEFT;
        } else if (CropWindowHandler.isInCornerTargetZone(x, y, this.mEdges.right, this.mEdges.bottom, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.BOTTOM_RIGHT;
        } else if (CropWindowHandler.isInCenterTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.right, this.mEdges.bottom) && this.focusCenter()) {
            moveType = CropWindowMoveHandler.Type.CENTER;
        } else if (CropWindowHandler.isInHorizontalTargetZone(x, y, this.mEdges.left, this.mEdges.right, this.mEdges.top, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.TOP;
        } else if (CropWindowHandler.isInHorizontalTargetZone(x, y, this.mEdges.left, this.mEdges.right, this.mEdges.bottom, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.BOTTOM;
        } else if (CropWindowHandler.isInVerticalTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.bottom, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.LEFT;
        } else if (CropWindowHandler.isInVerticalTargetZone(x, y, this.mEdges.right, this.mEdges.top, this.mEdges.bottom, targetRadius)) {
            moveType = CropWindowMoveHandler.Type.RIGHT;
        } else if (CropWindowHandler.isInCenterTargetZone(x, y, this.mEdges.left, this.mEdges.top, this.mEdges.right, this.mEdges.bottom) && !this.focusCenter()) {
            moveType = CropWindowMoveHandler.Type.CENTER;
        }
        return moveType;
    }

    private CropWindowMoveHandler.Type getOvalPressedMoveType(float x, float y) {
        float cellLength = this.mEdges.width() / 6.0f;
        float leftCenter = this.mEdges.left + cellLength;
        float rightCenter = this.mEdges.left + 5.0f * cellLength;
        float cellHeight = this.mEdges.height() / 6.0f;
        float topCenter = this.mEdges.top + cellHeight;
        float bottomCenter = this.mEdges.top + 5.0f * cellHeight;
        CropWindowMoveHandler.Type moveType = x < leftCenter ? (y < topCenter ? CropWindowMoveHandler.Type.TOP_LEFT : (y < bottomCenter ? CropWindowMoveHandler.Type.LEFT : CropWindowMoveHandler.Type.BOTTOM_LEFT)) : (x < rightCenter ? (y < topCenter ? CropWindowMoveHandler.Type.TOP : (y < bottomCenter ? CropWindowMoveHandler.Type.CENTER : CropWindowMoveHandler.Type.BOTTOM)) : (y < topCenter ? CropWindowMoveHandler.Type.TOP_RIGHT : (y < bottomCenter ? CropWindowMoveHandler.Type.RIGHT : CropWindowMoveHandler.Type.BOTTOM_RIGHT)));
        return moveType;
    }

    private static boolean isInCornerTargetZone(float x, float y, float handleX, float handleY, float targetRadius) {
        return Math.abs(x - handleX) <= targetRadius && Math.abs(y - handleY) <= targetRadius;
    }

    private static boolean isInHorizontalTargetZone(float x, float y, float handleXStart, float handleXEnd, float handleY, float targetRadius) {
        return x > handleXStart && x < handleXEnd && Math.abs(y - handleY) <= targetRadius;
    }

    private static boolean isInVerticalTargetZone(float x, float y, float handleX, float handleYStart, float handleYEnd, float targetRadius) {
        return Math.abs(x - handleX) <= targetRadius && y > handleYStart && y < handleYEnd;
    }

    private static boolean isInCenterTargetZone(float x, float y, float left, float top, float right, float bottom) {
        return x > left && x < right && y > top && y < bottom;
    }

    private boolean focusCenter() {
        return !this.showGuidelines();
    }
}

