/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import com.theartofdev.edmodo.cropper.CropWindowHandler;

final class CropWindowMoveHandler {
    private final CropWindowHandler mCropWindowHandler;
    private final Type mType;
    private final PointF mTouchOffset = new PointF();

    public CropWindowMoveHandler(Type type, CropWindowHandler cropWindowHandler, float touchX, float touchY) {
        this.mType = type;
        this.mCropWindowHandler = cropWindowHandler;
        this.calculateTouchOffset(touchX, touchY);
    }

    public void move(float x, float y, Rect bounds, float snapMargin, boolean fixedAspectRatio, float aspectRatio) {
        float adjX = x + this.mTouchOffset.x;
        float adjY = y + this.mTouchOffset.y;
        if (this.mType == Type.CENTER) {
            this.moveCenter(adjX, adjY, bounds, snapMargin);
        } else if (fixedAspectRatio) {
            this.moveSizeWithFixedAspectRatio(adjX, adjY, bounds, snapMargin, aspectRatio);
        } else {
            this.moveSizeWithFreeAspectRatio(adjX, adjY, bounds, snapMargin);
        }
    }

    private void calculateTouchOffset(float touchX, float touchY) {
        float touchOffsetX = 0.0f;
        float touchOffsetY = 0.0f;
        RectF rect = this.mCropWindowHandler.getRect();
        switch (this.mType) {
            case TOP_LEFT: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case TOP_RIGHT: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case BOTTOM_LEFT: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case BOTTOM_RIGHT: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case LEFT: {
                touchOffsetX = rect.left - touchX;
                touchOffsetY = 0.0f;
                break;
            }
            case TOP: {
                touchOffsetX = 0.0f;
                touchOffsetY = rect.top - touchY;
                break;
            }
            case RIGHT: {
                touchOffsetX = rect.right - touchX;
                touchOffsetY = 0.0f;
                break;
            }
            case BOTTOM: {
                touchOffsetX = 0.0f;
                touchOffsetY = rect.bottom - touchY;
                break;
            }
            case CENTER: {
                touchOffsetX = rect.centerX() - touchX;
                touchOffsetY = rect.centerY() - touchY;
                break;
            }
        }
        this.mTouchOffset.x = touchOffsetX;
        this.mTouchOffset.y = touchOffsetY;
    }

    private void moveCenter(float x, float y, Rect imageRect, float snapRadius) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.offset(x - rect.centerX(), y - rect.centerY());
        this.snapEdgesToBounds(rect, imageRect, snapRadius);
        this.mCropWindowHandler.setRect(rect);
    }

    private void moveSizeWithFreeAspectRatio(float x, float y, Rect bounds, float snapMargin) {
        switch (this.mType) {
            case TOP_LEFT: {
                this.adjustTop(y, bounds, snapMargin, 0.0f, false, false);
                this.adjustLeft(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case TOP_RIGHT: {
                this.adjustTop(y, bounds, snapMargin, 0.0f, false, false);
                this.adjustRight(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case BOTTOM_LEFT: {
                this.adjustBottom(y, bounds, snapMargin, 0.0f, false, false);
                this.adjustLeft(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case BOTTOM_RIGHT: {
                this.adjustBottom(y, bounds, snapMargin, 0.0f, false, false);
                this.adjustRight(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case LEFT: {
                this.adjustLeft(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case TOP: {
                this.adjustTop(y, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case RIGHT: {
                this.adjustRight(x, bounds, snapMargin, 0.0f, false, false);
                break;
            }
            case BOTTOM: {
                this.adjustBottom(y, bounds, snapMargin, 0.0f, false, false);
                break;
            }
        }
    }

    private void moveSizeWithFixedAspectRatio(float x, float y, Rect bounds, float snapMargin, float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        switch (this.mType) {
            case TOP_LEFT: {
                if (CropWindowMoveHandler.calculateAspectRatio(x, y, rect.right, rect.bottom) < aspectRatio) {
                    this.adjustTop(y, bounds, snapMargin, aspectRatio, true, false);
                    this.adjustLeftByAspectRatio(aspectRatio);
                    break;
                }
                this.adjustLeft(x, bounds, snapMargin, aspectRatio, true, false);
                this.adjustTopByAspectRatio(aspectRatio);
                break;
            }
            case TOP_RIGHT: {
                if (CropWindowMoveHandler.calculateAspectRatio(rect.left, y, x, rect.bottom) < aspectRatio) {
                    this.adjustTop(y, bounds, snapMargin, aspectRatio, false, true);
                    this.adjustRightByAspectRatio(aspectRatio);
                    break;
                }
                this.adjustRight(x, bounds, snapMargin, aspectRatio, true, false);
                this.adjustTopByAspectRatio(aspectRatio);
                break;
            }
            case BOTTOM_LEFT: {
                if (CropWindowMoveHandler.calculateAspectRatio(x, rect.top, rect.right, y) < aspectRatio) {
                    this.adjustBottom(y, bounds, snapMargin, aspectRatio, true, false);
                    this.adjustLeftByAspectRatio(aspectRatio);
                    break;
                }
                this.adjustLeft(x, bounds, snapMargin, aspectRatio, false, true);
                this.adjustBottomByAspectRatio(aspectRatio);
                break;
            }
            case BOTTOM_RIGHT: {
                if (CropWindowMoveHandler.calculateAspectRatio(rect.left, rect.top, x, y) < aspectRatio) {
                    this.adjustBottom(y, bounds, snapMargin, aspectRatio, false, true);
                    this.adjustRightByAspectRatio(aspectRatio);
                    break;
                }
                this.adjustRight(x, bounds, snapMargin, aspectRatio, false, true);
                this.adjustBottomByAspectRatio(aspectRatio);
                break;
            }
            case LEFT: {
                this.adjustLeft(x, bounds, snapMargin, aspectRatio, true, true);
                this.adjustTopBottomByAspectRatio(bounds, aspectRatio);
                break;
            }
            case TOP: {
                this.adjustTop(y, bounds, snapMargin, aspectRatio, true, true);
                this.adjustLeftRightByAspectRatio(bounds, aspectRatio);
                break;
            }
            case RIGHT: {
                this.adjustRight(x, bounds, snapMargin, aspectRatio, true, true);
                this.adjustTopBottomByAspectRatio(bounds, aspectRatio);
                break;
            }
            case BOTTOM: {
                this.adjustBottom(y, bounds, snapMargin, aspectRatio, true, true);
                this.adjustLeftRightByAspectRatio(bounds, aspectRatio);
                break;
            }
        }
    }

    private void snapEdgesToBounds(RectF edges, Rect bounds, float margin) {
        if (edges.left < (float)bounds.left + margin) {
            edges.offset((float)bounds.left - edges.left, 0.0f);
        }
        if (edges.top < (float)bounds.top + margin) {
            edges.offset(0.0f, (float)bounds.top - edges.top);
        }
        if (edges.right > (float)bounds.right - margin) {
            edges.offset((float)bounds.right - edges.right, 0.0f);
        }
        if (edges.bottom > (float)bounds.bottom - margin) {
            edges.offset(0.0f, (float)bounds.bottom - edges.bottom);
        }
    }

    private void adjustLeft(float left, Rect bounds, float snapMargin, float aspectRatio, boolean topMoves, boolean bottomMoves) {
        RectF rect = this.mCropWindowHandler.getRect();
        float newLeft = left;
        if (newLeft - (float)bounds.left < snapMargin) {
            newLeft = bounds.left;
        }
        if (rect.right - newLeft < this.mCropWindowHandler.getMinCropWidth()) {
            newLeft = rect.right - this.mCropWindowHandler.getMinCropWidth();
        }
        if (rect.right - newLeft > this.mCropWindowHandler.getMaxCropWidth()) {
            newLeft = rect.right - this.mCropWindowHandler.getMaxCropWidth();
        }
        if (newLeft - (float)bounds.left < snapMargin) {
            newLeft = bounds.left;
        }
        if (aspectRatio > 0.0f) {
            float newHeight = (rect.right - newLeft) / aspectRatio;
            if (newHeight < this.mCropWindowHandler.getMinCropHeight()) {
                newLeft = Math.max((float)bounds.left, rect.right - this.mCropWindowHandler.getMinCropHeight() * aspectRatio);
                newHeight = (rect.right - newLeft) / aspectRatio;
            }
            if (newHeight > this.mCropWindowHandler.getMaxCropHeight()) {
                newLeft = Math.max((float)bounds.left, rect.right - this.mCropWindowHandler.getMaxCropHeight() * aspectRatio);
                newHeight = (rect.right - newLeft) / aspectRatio;
            }
            if (topMoves && bottomMoves) {
                newLeft = Math.max(newLeft, Math.max((float)bounds.left, rect.right - (float)bounds.height() * aspectRatio));
            } else {
                if (topMoves && rect.bottom - newHeight < (float)bounds.top) {
                    newLeft = Math.max((float)bounds.left, rect.right - (rect.bottom - (float)bounds.top) * aspectRatio);
                    newHeight = (rect.right - newLeft) / aspectRatio;
                }
                if (bottomMoves && rect.top + newHeight > (float)bounds.bottom) {
                    newLeft = Math.max(newLeft, Math.max((float)bounds.left, rect.right - ((float)bounds.bottom - rect.top) * aspectRatio));
                }
            }
        }
        rect.left = newLeft;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustRight(float right, Rect bounds, float snapMargin, float aspectRatio, boolean topMoves, boolean bottomMoves) {
        RectF rect = this.mCropWindowHandler.getRect();
        float newRight = right;
        if ((float)bounds.right - newRight < snapMargin) {
            newRight = bounds.right;
        }
        if (newRight - rect.left < this.mCropWindowHandler.getMinCropWidth()) {
            newRight = rect.left + this.mCropWindowHandler.getMinCropWidth();
        }
        if (newRight - rect.left > this.mCropWindowHandler.getMaxCropWidth()) {
            newRight = rect.left + this.mCropWindowHandler.getMaxCropWidth();
        }
        if ((float)bounds.right - newRight < snapMargin) {
            newRight = bounds.right;
        }
        if (aspectRatio > 0.0f) {
            float newHeight = (newRight - rect.left) / aspectRatio;
            if (newHeight < this.mCropWindowHandler.getMinCropHeight()) {
                newRight = Math.min((float)bounds.right, rect.left + this.mCropWindowHandler.getMinCropHeight() * aspectRatio);
                newHeight = (newRight - rect.left) / aspectRatio;
            }
            if (newHeight > this.mCropWindowHandler.getMaxCropHeight()) {
                newRight = Math.min((float)bounds.right, rect.left + this.mCropWindowHandler.getMaxCropHeight() * aspectRatio);
                newHeight = (newRight - rect.left) / aspectRatio;
            }
            if (topMoves && bottomMoves) {
                newRight = Math.min(newRight, Math.min((float)bounds.right, rect.left + (float)bounds.height() * aspectRatio));
            } else {
                if (topMoves && rect.bottom - newHeight < (float)bounds.top) {
                    newRight = Math.min((float)bounds.right, rect.left + (rect.bottom - (float)bounds.top) * aspectRatio);
                    newHeight = (newRight - rect.left) / aspectRatio;
                }
                if (bottomMoves && rect.top + newHeight > (float)bounds.bottom) {
                    newRight = Math.min(newRight, Math.min((float)bounds.right, rect.left + ((float)bounds.bottom - rect.top) * aspectRatio));
                }
            }
        }
        rect.right = newRight;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustTop(float top, Rect bounds, float snapMargin, float aspectRatio, boolean leftMoves, boolean rightMoves) {
        RectF rect = this.mCropWindowHandler.getRect();
        float newTop = top;
        if (newTop - (float)bounds.top < snapMargin) {
            newTop = bounds.top;
        }
        if (rect.bottom - newTop < this.mCropWindowHandler.getMinCropHeight()) {
            newTop = rect.bottom - this.mCropWindowHandler.getMinCropHeight();
        }
        if (rect.bottom - newTop > this.mCropWindowHandler.getMaxCropHeight()) {
            newTop = rect.bottom - this.mCropWindowHandler.getMaxCropHeight();
        }
        if (newTop - (float)bounds.top < snapMargin) {
            newTop = bounds.top;
        }
        if (aspectRatio > 0.0f) {
            float newWidth = (rect.bottom - newTop) * aspectRatio;
            if (newWidth < this.mCropWindowHandler.getMinCropWidth()) {
                newTop = Math.max((float)bounds.top, rect.bottom - this.mCropWindowHandler.getMinCropWidth() / aspectRatio);
                newWidth = (rect.bottom - newTop) * aspectRatio;
            }
            if (newWidth > this.mCropWindowHandler.getMaxCropWidth()) {
                newTop = Math.max((float)bounds.top, rect.bottom - this.mCropWindowHandler.getMaxCropWidth() / aspectRatio);
                newWidth = (rect.bottom - newTop) * aspectRatio;
            }
            if (leftMoves && rightMoves) {
                newTop = Math.max(newTop, Math.max((float)bounds.top, rect.bottom - (float)bounds.width() / aspectRatio));
            } else {
                if (leftMoves && rect.right - newWidth < (float)bounds.left) {
                    newTop = Math.max((float)bounds.top, rect.bottom - (rect.right - (float)bounds.left) / aspectRatio);
                    newWidth = (rect.bottom - newTop) * aspectRatio;
                }
                if (rightMoves && rect.left + newWidth > (float)bounds.right) {
                    newTop = Math.max(newTop, Math.max((float)bounds.top, rect.bottom - ((float)bounds.right - rect.left) / aspectRatio));
                }
            }
        }
        rect.top = newTop;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustBottom(float bottom, Rect bounds, float snapMargin, float aspectRatio, boolean leftMoves, boolean rightMoves) {
        RectF rect = this.mCropWindowHandler.getRect();
        float newBottom = bottom;
        if ((float)bounds.bottom - newBottom < snapMargin) {
            newBottom = bounds.bottom;
        }
        if (newBottom - rect.top < this.mCropWindowHandler.getMinCropHeight()) {
            newBottom = rect.top + this.mCropWindowHandler.getMinCropHeight();
        }
        if (newBottom - rect.top > this.mCropWindowHandler.getMaxCropHeight()) {
            newBottom = rect.top + this.mCropWindowHandler.getMaxCropHeight();
        }
        if ((float)bounds.bottom - newBottom < snapMargin) {
            newBottom = bounds.bottom;
        }
        if (aspectRatio > 0.0f) {
            float newWidth = (newBottom - rect.top) * aspectRatio;
            if (newWidth < this.mCropWindowHandler.getMinCropWidth()) {
                newBottom = Math.min((float)bounds.bottom, rect.top + this.mCropWindowHandler.getMinCropWidth() / aspectRatio);
                newWidth = (newBottom - rect.top) * aspectRatio;
            }
            if (newWidth > this.mCropWindowHandler.getMaxCropWidth()) {
                newBottom = Math.min((float)bounds.bottom, rect.top + this.mCropWindowHandler.getMaxCropWidth() / aspectRatio);
                newWidth = (newBottom - rect.top) * aspectRatio;
            }
            if (leftMoves && rightMoves) {
                newBottom = Math.min(newBottom, Math.min((float)bounds.bottom, rect.top + (float)bounds.width() / aspectRatio));
            } else {
                if (leftMoves && rect.right - newWidth < (float)bounds.left) {
                    newBottom = Math.min((float)bounds.bottom, rect.top + (rect.right - (float)bounds.left) / aspectRatio);
                    newWidth = (newBottom - rect.top) * aspectRatio;
                }
                if (rightMoves && rect.left + newWidth > (float)bounds.right) {
                    newBottom = Math.min(newBottom, Math.min((float)bounds.bottom, rect.top + ((float)bounds.right - rect.left) / aspectRatio));
                }
            }
        }
        rect.bottom = newBottom;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustLeftByAspectRatio(float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.left = rect.right - rect.height() * aspectRatio;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustTopByAspectRatio(float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.top = rect.bottom - rect.width() / aspectRatio;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustRightByAspectRatio(float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.right = rect.left + rect.height() * aspectRatio;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustBottomByAspectRatio(float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.bottom = rect.top + rect.width() / aspectRatio;
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustLeftRightByAspectRatio(Rect bounds, float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.inset((rect.width() - rect.height() * aspectRatio) / 2.0f, 0.0f);
        if (rect.left < (float)bounds.left) {
            rect.offset((float)bounds.left - rect.left, 0.0f);
        }
        if (rect.right > (float)bounds.right) {
            rect.offset((float)bounds.right - rect.right, 0.0f);
        }
        this.mCropWindowHandler.setRect(rect);
    }

    private void adjustTopBottomByAspectRatio(Rect bounds, float aspectRatio) {
        RectF rect = this.mCropWindowHandler.getRect();
        rect.inset(0.0f, (rect.height() - rect.width() / aspectRatio) / 2.0f);
        if (rect.top < (float)bounds.top) {
            rect.offset(0.0f, (float)bounds.top - rect.top);
        }
        if (rect.bottom > (float)bounds.bottom) {
            rect.offset(0.0f, (float)bounds.bottom - rect.bottom);
        }
        this.mCropWindowHandler.setRect(rect);
    }

    private static float calculateAspectRatio(float left, float top, float right, float bottom) {
        return (right - left) / (bottom - top);
    }

    public static enum Type {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        CENTER;

    }
}

