/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.theartofdev.edmodo.cropper.CropDefaults;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.CropWindowHandler;
import com.theartofdev.edmodo.cropper.CropWindowMoveHandler;

public class CropOverlayView
extends View {
    private final CropWindowHandler mCropWindowHandler = new CropWindowHandler();
    private Paint mBorderPaint;
    private Paint mBorderCornerPaint;
    private Paint mGuidelinePaint;
    private Paint mBackgroundPaint;
    private Rect mBitmapRect;
    private float mBorderCornerOffset;
    private float mBorderCornerLength;
    private float mInitialCropWindowPaddingRatio;
    private float mTouchRadius;
    private float mSnapRadius;
    private CropWindowMoveHandler mMoveHandler;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private float mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    private CropImageView.Guidelines mGuidelines;
    private CropImageView.CropShape mCropShape;
    private Rect mInitialCropWindowRect;
    private boolean initializedCropWindow;
    private Integer mOriginalLayerType;

    public CropOverlayView(Context context) {
        this(context, null);
    }

    public CropOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RectF getCropWindowRect() {
        return this.mCropWindowHandler.getRect();
    }

    public void setBitmapRect(Rect bitmapRect) {
        if (this.mBitmapRect == null || !bitmapRect.equals((Object)this.mBitmapRect)) {
            this.mBitmapRect = bitmapRect;
            this.initCropWindow();
        }
    }

    public void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
        }
    }

    public CropImageView.CropShape getCropShape() {
        return this.mCropShape;
    }

    public void setCropShape(CropImageView.CropShape cropShape) {
        if (this.mCropShape != cropShape) {
            this.mCropShape = cropShape;
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 17) {
                if (this.mCropShape == CropImageView.CropShape.OVAL) {
                    this.mOriginalLayerType = this.getLayerType();
                    if (this.mOriginalLayerType != 1) {
                        this.setLayerType(1, null);
                    } else {
                        this.mOriginalLayerType = null;
                    }
                } else if (this.mOriginalLayerType != null) {
                    this.setLayerType(this.mOriginalLayerType, null);
                    this.mOriginalLayerType = null;
                }
            }
            this.invalidate();
        }
    }

    public CropImageView.Guidelines getGuidelines() {
        return this.mGuidelines;
    }

    public void setGuidelines(CropImageView.Guidelines guidelines) {
        if (this.mGuidelines != guidelines) {
            this.mGuidelines = guidelines;
            if (this.initializedCropWindow) {
                this.invalidate();
            }
        }
    }

    public boolean isFixAspectRatio() {
        return this.mFixAspectRatio;
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        if (this.mFixAspectRatio != fixAspectRatio) {
            this.mFixAspectRatio = fixAspectRatio;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public int getAspectRatioX() {
        return this.mAspectRatioX;
    }

    public void setAspectRatioX(int aspectRatioX) {
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        if (this.mAspectRatioX != aspectRatioX) {
            this.mAspectRatioX = aspectRatioX;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public int getAspectRatioY() {
        return this.mAspectRatioY;
    }

    public void setAspectRatioY(int aspectRatioY) {
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        if (this.mAspectRatioY != aspectRatioY) {
            this.mAspectRatioY = aspectRatioY;
            this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
            if (this.initializedCropWindow) {
                this.initCropWindow();
                this.invalidate();
            }
        }
    }

    public void setSnapRadius(float snapRadius) {
        this.mSnapRadius = snapRadius;
    }

    public void setScaleFactor(float scaleFactorWidth, float scaleFactorHeight) {
        this.mCropWindowHandler.setScaleFactor(scaleFactorWidth, scaleFactorHeight);
    }

    public Rect getInitialCropWindowRect() {
        return this.mInitialCropWindowRect;
    }

    public void setInitialCropWindowRect(Rect rect) {
        this.mInitialCropWindowRect = rect;
        if (this.initializedCropWindow) {
            this.initCropWindow();
            this.invalidate();
        }
    }

    public void setInitialAttributeValues(CropImageView.CropShape cropShape, float snapRadius, float touchRadius, CropImageView.Guidelines guidelines, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, float initialCropWindowPaddingRatio, float borderLineThickness, int borderLineColor, float borderCornerThickness, float borderCornerOffset, float borderCornerLength, int borderCornerColor, float guidelinesThickness, int guidelinesColor, int backgroundColor, float minCropWindowWidth, float minCropWindowHeight, float minCropResultWidth, float minCropResultHeight, float maxCropResultWidth, float maxCropResultHeight) {
        this.mCropWindowHandler.setInitialAttributeValues(minCropWindowWidth, minCropWindowHeight, minCropResultWidth, minCropResultHeight, maxCropResultWidth, maxCropResultHeight);
        this.setCropShape(cropShape);
        this.setSnapRadius(snapRadius);
        this.setGuidelines(guidelines);
        this.setFixedAspectRatio(fixAspectRatio);
        this.setAspectRatioX(aspectRatioX);
        this.setAspectRatioY(aspectRatioY);
        if (touchRadius < 0.0f) {
            throw new IllegalArgumentException("Cannot set touch radius value to a number <= 0 ");
        }
        this.mTouchRadius = touchRadius;
        if (initialCropWindowPaddingRatio < 0.0f || (double)initialCropWindowPaddingRatio >= 0.5) {
            throw new IllegalArgumentException("Cannot set initial crop window padding value to a number < 0 or >= 0.5");
        }
        this.mInitialCropWindowPaddingRatio = initialCropWindowPaddingRatio;
        if (borderLineThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set line thickness value to a number less than 0.");
        }
        this.mBorderPaint = CropOverlayView.getNewPaintOrNull(borderLineThickness, borderLineColor);
        if (borderCornerThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set corner thickness value to a number less than 0.");
        }
        this.mBorderCornerOffset = borderCornerOffset;
        this.mBorderCornerLength = borderCornerLength;
        this.mBorderCornerPaint = CropOverlayView.getNewPaintOrNull(borderCornerThickness, borderCornerColor);
        if (guidelinesThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set guidelines thickness value to a number less than 0.");
        }
        this.mGuidelinePaint = CropOverlayView.getNewPaintOrNull(guidelinesThickness, guidelinesColor);
        this.mBackgroundPaint = CropOverlayView.getNewPaint(backgroundColor);
    }

    private void initCropWindow() {
        if (this.mBitmapRect.width() == 0 || this.mBitmapRect.height() == 0) {
            return;
        }
        RectF rect = new RectF();
        this.initializedCropWindow = true;
        float horizontalPadding = this.mInitialCropWindowPaddingRatio * (float)this.mBitmapRect.width();
        float verticalPadding = this.mInitialCropWindowPaddingRatio * (float)this.mBitmapRect.height();
        if (this.mInitialCropWindowRect != null && this.mInitialCropWindowRect.width() > 0 && this.mInitialCropWindowRect.height() > 0) {
            rect.left = (float)this.mBitmapRect.left + (float)this.mInitialCropWindowRect.left / this.mCropWindowHandler.getScaleFactorWidth();
            rect.top = (float)this.mBitmapRect.top + (float)this.mInitialCropWindowRect.top / this.mCropWindowHandler.getScaleFactorHeight();
            rect.right = rect.left + (float)this.mInitialCropWindowRect.width() / this.mCropWindowHandler.getScaleFactorWidth();
            rect.bottom = rect.top + (float)this.mInitialCropWindowRect.height() / this.mCropWindowHandler.getScaleFactorHeight();
            rect.left = Math.max((float)this.mBitmapRect.left, rect.left);
            rect.top = Math.max((float)this.mBitmapRect.top, rect.top);
            rect.right = Math.min((float)this.mBitmapRect.right, rect.right);
            rect.bottom = Math.min((float)this.mBitmapRect.bottom, rect.bottom);
        } else if (this.mFixAspectRatio && !this.mBitmapRect.isEmpty()) {
            float bitmapAspectRatio = (float)this.mBitmapRect.width() / (float)this.mBitmapRect.height();
            if (bitmapAspectRatio > this.mTargetAspectRatio) {
                rect.top = (float)this.mBitmapRect.top + verticalPadding;
                rect.bottom = (float)this.mBitmapRect.bottom - verticalPadding;
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float cropWidth = Math.max(this.mCropWindowHandler.getMinCropWidth(), rect.height() * this.mTargetAspectRatio);
                float halfCropWidth = cropWidth / 2.0f;
                rect.left = centerX - halfCropWidth;
                rect.right = centerX + halfCropWidth;
            } else {
                rect.left = (float)this.mBitmapRect.left + horizontalPadding;
                rect.right = (float)this.mBitmapRect.right - horizontalPadding;
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(this.mCropWindowHandler.getMinCropHeight(), rect.width() / this.mTargetAspectRatio);
                float halfCropHeight = cropHeight / 2.0f;
                rect.top = centerY - halfCropHeight;
                rect.bottom = centerY + halfCropHeight;
            }
        } else {
            rect.left = (float)this.mBitmapRect.left + horizontalPadding;
            rect.top = (float)this.mBitmapRect.top + verticalPadding;
            rect.right = (float)this.mBitmapRect.right - horizontalPadding;
            rect.bottom = (float)this.mBitmapRect.bottom - verticalPadding;
        }
        this.fixCropWindowRectByRules(rect);
        this.mCropWindowHandler.setRect(rect);
    }

    private void fixCropWindowRectByRules(RectF rect) {
        float adj;
        if (rect.width() < this.mCropWindowHandler.getMinCropWidth()) {
            adj = (this.mCropWindowHandler.getMinCropWidth() - rect.width()) / 2.0f;
            rect.left -= adj;
            rect.right += adj;
        }
        if (rect.height() < this.mCropWindowHandler.getMinCropHeight()) {
            adj = (this.mCropWindowHandler.getMinCropHeight() - rect.height()) / 2.0f;
            rect.top -= adj;
            rect.bottom += adj;
        }
        if (rect.width() > this.mCropWindowHandler.getMaxCropWidth()) {
            adj = (rect.width() - this.mCropWindowHandler.getMaxCropWidth()) / 2.0f;
            rect.left += adj;
            rect.right -= adj;
        }
        if (rect.height() > this.mCropWindowHandler.getMaxCropHeight()) {
            adj = (rect.height() - this.mCropWindowHandler.getMaxCropHeight()) / 2.0f;
            rect.top += adj;
            rect.bottom -= adj;
        }
        if (this.mBitmapRect != null && this.mBitmapRect.width() > 0 && this.mBitmapRect.height() > 0) {
            if (rect.left < (float)this.mBitmapRect.left) {
                rect.left = this.mBitmapRect.left;
            }
            if (rect.top < (float)this.mBitmapRect.top) {
                rect.top = this.mBitmapRect.top;
            }
            if (rect.right > (float)this.mBitmapRect.right) {
                rect.right = this.mBitmapRect.right;
            }
            if (rect.bottom > (float)this.mBitmapRect.bottom) {
                rect.bottom = this.mBitmapRect.bottom;
            }
        }
        if (this.mFixAspectRatio && (double)Math.abs(rect.width() - rect.height() * this.mTargetAspectRatio) > 0.1) {
            if (rect.width() > rect.height() * this.mTargetAspectRatio) {
                adj = Math.abs(rect.height() * this.mTargetAspectRatio - rect.width()) / 2.0f;
                rect.left += adj;
                rect.right -= adj;
            } else {
                adj = Math.abs(rect.width() / this.mTargetAspectRatio - rect.height()) / 2.0f;
                rect.top += adj;
                rect.bottom -= adj;
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.initCropWindow();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas, this.mBitmapRect);
        if (this.mCropWindowHandler.showGuidelines()) {
            if (this.mGuidelines == CropImageView.Guidelines.ON) {
                this.drawGuidelines(canvas);
            } else if (this.mGuidelines == CropImageView.Guidelines.ON_TOUCH && this.mMoveHandler != null) {
                this.drawGuidelines(canvas);
            }
        }
        this.drawBorders(canvas);
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            this.drawCorners(canvas);
        }
    }

    private void drawBackground(Canvas canvas, Rect bitmapRect) {
        RectF rect = this.mCropWindowHandler.getRect();
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, rect.top, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, rect.bottom, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, rect.top, rect.left, rect.bottom, this.mBackgroundPaint);
            canvas.drawRect(rect.right, rect.top, (float)bitmapRect.right, rect.bottom, this.mBackgroundPaint);
        } else {
            Path circleSelectionPath = new Path();
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 17 && this.mCropShape == CropImageView.CropShape.OVAL) {
                CropDefaults.EMPTY_RECT_F.set(rect.left + 2.0f, rect.top + 2.0f, rect.right - 2.0f, rect.bottom - 2.0f);
            } else {
                CropDefaults.EMPTY_RECT_F.set(rect.left, rect.top, rect.right, rect.bottom);
            }
            circleSelectionPath.addOval(CropDefaults.EMPTY_RECT_F, Path.Direction.CW);
            canvas.save();
            canvas.clipPath(circleSelectionPath, Region.Op.XOR);
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.restore();
        }
    }

    private void drawGuidelines(Canvas canvas) {
        if (this.mGuidelinePaint != null) {
            float sw = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(sw, sw);
            float oneThirdCropWidth = rect.width() / 3.0f;
            float oneThirdCropHeight = rect.height() / 3.0f;
            if (this.mCropShape == CropImageView.CropShape.OVAL) {
                float w = rect.width() / 2.0f - sw;
                float h = rect.height() / 2.0f - sw;
                float x1 = rect.left + oneThirdCropWidth;
                float x2 = rect.right - oneThirdCropWidth;
                float yv = (float)((double)h * Math.sin(Math.acos((w - oneThirdCropWidth) / w)));
                canvas.drawLine(x1, rect.top + h - yv, x1, rect.bottom - h + yv, this.mGuidelinePaint);
                canvas.drawLine(x2, rect.top + h - yv, x2, rect.bottom - h + yv, this.mGuidelinePaint);
                float y1 = rect.top + oneThirdCropHeight;
                float y2 = rect.bottom - oneThirdCropHeight;
                float xv = (float)((double)w * Math.cos(Math.asin((h - oneThirdCropHeight) / h)));
                canvas.drawLine(rect.left + w - xv, y1, rect.right - w + xv, y1, this.mGuidelinePaint);
                canvas.drawLine(rect.left + w - xv, y2, rect.right - w + xv, y2, this.mGuidelinePaint);
            } else {
                float x1 = rect.left + oneThirdCropWidth;
                float x2 = rect.right - oneThirdCropWidth;
                canvas.drawLine(x1, rect.top, x1, rect.bottom, this.mGuidelinePaint);
                canvas.drawLine(x2, rect.top, x2, rect.bottom, this.mGuidelinePaint);
                float y1 = rect.top + oneThirdCropHeight;
                float y2 = rect.bottom - oneThirdCropHeight;
                canvas.drawLine(rect.left, y1, rect.right, y1, this.mGuidelinePaint);
                canvas.drawLine(rect.left, y2, rect.right, y2, this.mGuidelinePaint);
            }
        }
    }

    private void drawBorders(Canvas canvas) {
        if (this.mBorderPaint != null) {
            float w = this.mBorderPaint.getStrokeWidth();
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w / 2.0f, w / 2.0f);
            if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
                canvas.drawRect(rect, this.mBorderPaint);
            } else {
                canvas.drawOval(rect, this.mBorderPaint);
            }
        }
    }

    private void drawCorners(Canvas canvas) {
        if (this.mBorderCornerPaint != null) {
            float lineWidth = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            float cornerWidth = this.mBorderCornerPaint.getStrokeWidth();
            float w = cornerWidth / 2.0f + this.mBorderCornerOffset;
            RectF rect = this.mCropWindowHandler.getRect();
            rect.inset(w, w);
            float cornerOffset = (cornerWidth - lineWidth) / 2.0f;
            float cornerExtension = cornerWidth / 2.0f + cornerOffset;
            canvas.drawLine(rect.left - cornerOffset, rect.top - cornerExtension, rect.left - cornerOffset, rect.top + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerExtension, rect.top - cornerOffset, rect.left + this.mBorderCornerLength, rect.top - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerOffset, rect.top - cornerExtension, rect.right + cornerOffset, rect.top + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerExtension, rect.top - cornerOffset, rect.right - this.mBorderCornerLength, rect.top - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerOffset, rect.bottom + cornerExtension, rect.left - cornerOffset, rect.bottom - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.left - cornerExtension, rect.bottom + cornerOffset, rect.left + this.mBorderCornerLength, rect.bottom + cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerOffset, rect.bottom + cornerExtension, rect.right + cornerOffset, rect.bottom - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(rect.right + cornerExtension, rect.bottom + cornerOffset, rect.right - this.mBorderCornerLength, rect.bottom + cornerOffset, this.mBorderCornerPaint);
        }
    }

    private static Paint getNewPaint(int color) {
        Paint paint = new Paint();
        paint.setColor(color);
        return paint;
    }

    private static Paint getNewPaintOrNull(float thickness, int color) {
        if (thickness > 0.0f) {
            Paint borderPaint = new Paint();
            borderPaint.setColor(color);
            borderPaint.setStrokeWidth(thickness);
            borderPaint.setStyle(Paint.Style.STROKE);
            borderPaint.setAntiAlias(true);
            return borderPaint;
        }
        return null;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEnabled()) {
            switch (event.getAction()) {
                case 0: {
                    this.onActionDown(event.getX(), event.getY());
                    return true;
                }
                case 1: 
                case 3: {
                    this.getParent().requestDisallowInterceptTouchEvent(false);
                    this.onActionUp();
                    return true;
                }
                case 2: {
                    this.onActionMove(event.getX(), event.getY());
                    this.getParent().requestDisallowInterceptTouchEvent(true);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void onActionDown(float x, float y) {
        this.mMoveHandler = this.mCropWindowHandler.getMoveHandler(x, y, this.mTouchRadius, this.mCropShape);
        if (this.mMoveHandler != null) {
            this.invalidate();
        }
    }

    private void onActionUp() {
        if (this.mMoveHandler != null) {
            this.mMoveHandler = null;
            this.invalidate();
        }
    }

    private void onActionMove(float x, float y) {
        if (this.mMoveHandler != null) {
            this.mMoveHandler.move(x, y, this.mBitmapRect, this.mSnapRadius, this.mFixAspectRatio, this.mTargetAspectRatio);
            this.invalidate();
        }
    }
}

