/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.app.Activity;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Parcelable;
import android.system.ErrnoException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class CropImageHelper {
    public static final int PICK_IMAGE_CHOOSER_REQUEST_CODE = 200;
    public static final int PICK_IMAGE_PERMISSIONS_REQUEST_CODE = 201;

    private CropImageHelper() {
    }

    public static void startPickImageActivity(Activity activity) {
        activity.startActivityForResult(CropImageHelper.getPickImageChooserIntent((Context)activity), 200);
    }

    public static Intent getPickImageChooserIntent(Context context) {
        Uri outputFileUri = CropImageHelper.getCaptureImageOutputUri(context);
        ArrayList<Object> allIntents = new ArrayList<Object>();
        PackageManager packageManager = context.getPackageManager();
        Intent captureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        List listCam = packageManager.queryIntentActivities(captureIntent, 0);
        for (ResolveInfo res : listCam) {
            Intent intent = new Intent(captureIntent);
            intent.setComponent(new ComponentName(res.activityInfo.packageName, res.activityInfo.name));
            intent.setPackage(res.activityInfo.packageName);
            if (outputFileUri != null) {
                intent.putExtra("output", (Parcelable)outputFileUri);
            }
            allIntents.add(intent);
        }
        Intent galleryIntent = new Intent("android.intent.action.GET_CONTENT");
        galleryIntent.setType("image/*");
        List listGallery = packageManager.queryIntentActivities(galleryIntent, 0);
        for (Object res : listGallery) {
            Intent intent = new Intent(galleryIntent);
            intent.setComponent(new ComponentName(((ResolveInfo)res).activityInfo.packageName, ((ResolveInfo)res).activityInfo.name));
            intent.setPackage(((ResolveInfo)res).activityInfo.packageName);
            allIntents.add(intent);
        }
        Intent mainIntent = (Intent)allIntents.get(allIntents.size() - 1);
        for (Intent intent : allIntents) {
            if (!intent.getComponent().getClassName().equals("com.android.documentsui.DocumentsActivity")) continue;
            mainIntent = intent;
            break;
        }
        allIntents.remove(mainIntent);
        Intent chooserIntent = Intent.createChooser((Intent)mainIntent, (CharSequence)"Select source");
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", allIntents.toArray(new Parcelable[allIntents.size()]));
        return chooserIntent;
    }

    public static Uri getCaptureImageOutputUri(Context context) {
        Uri outputFileUri = null;
        File getImage = context.getExternalCacheDir();
        if (getImage != null) {
            outputFileUri = Uri.fromFile((File)new File(getImage.getPath(), "pickImageResult.jpeg"));
        }
        return outputFileUri;
    }

    public static Uri getPickImageResultUri(Context context, Intent data) {
        boolean isCamera = true;
        if (data != null && data.getData() != null) {
            String action = data.getAction();
            isCamera = action != null && action.equals("android.media.action.IMAGE_CAPTURE");
        }
        return isCamera ? CropImageHelper.getCaptureImageOutputUri(context) : data.getData();
    }

    public static boolean isReadExternalStoragePermissionsRequired(Context context, Uri uri) {
        return Build.VERSION.SDK_INT >= 23 && context.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") != 0 && CropImageHelper.isUriRequiresPermissions(context, uri);
    }

    public static boolean isUriRequiresPermissions(Context context, Uri uri) {
        try {
            ContentResolver resolver = context.getContentResolver();
            InputStream stream = resolver.openInputStream(uri);
            stream.close();
            return false;
        }
        catch (FileNotFoundException e) {
            if (e.getCause() instanceof ErrnoException) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

