/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.graphics.Rect;
import android.view.View;
import com.theartofdev.edmodo.cropper.util.AspectRatioUtil;
import java.security.InvalidParameterException;

public enum Edge {
    LEFT,
    TOP,
    RIGHT,
    BOTTOM;

    public static final int MIN_CROP_VERTICAL_LENGTH = 60;
    public static final int MIN_CROP_HORIZONTAL_LENGTH = 60;
    private float mCoordinate;

    public void setCoordinate(float coordinate) {
        this.mCoordinate = coordinate;
    }

    public void offset(float distance) {
        this.mCoordinate += distance;
    }

    public float getCoordinate() {
        return this.mCoordinate;
    }

    public void adjustCoordinate(float x, float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = Edge.adjustLeft(x, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case TOP: {
                this.mCoordinate = Edge.adjustTop(y, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case RIGHT: {
                this.mCoordinate = Edge.adjustRight(x, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = Edge.adjustBottom(y, imageRect, imageSnapRadius, aspectRatio);
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
    }

    public void adjustCoordinate(float aspectRatio) {
        float left = LEFT.getCoordinate();
        float top = TOP.getCoordinate();
        float right = RIGHT.getCoordinate();
        float bottom = BOTTOM.getCoordinate();
        switch (this) {
            case LEFT: {
                this.mCoordinate = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                break;
            }
            case TOP: {
                this.mCoordinate = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                break;
            }
            case RIGHT: {
                this.mCoordinate = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                break;
            }
            case BOTTOM: {
                this.mCoordinate = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
    }

    public boolean isNewRectangleOutOfBounds(Edge edge, Rect imageRect, float aspectRatio) {
        float offset = edge.snapOffset(imageRect);
        switch (this) {
            case LEFT: {
                if (edge.equals((Object)TOP)) {
                    float top = imageRect.top;
                    float bottom = BOTTOM.getCoordinate() - offset;
                    float right = RIGHT.getCoordinate();
                    float left = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float bottom = imageRect.bottom;
                float top = TOP.getCoordinate() - offset;
                float right = RIGHT.getCoordinate();
                float left = AspectRatioUtil.calculateLeft(top, right, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case TOP: {
                if (edge.equals((Object)LEFT)) {
                    float left = imageRect.left;
                    float right = RIGHT.getCoordinate() - offset;
                    float bottom = BOTTOM.getCoordinate();
                    float top = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float right = imageRect.right;
                float left = LEFT.getCoordinate() - offset;
                float bottom = BOTTOM.getCoordinate();
                float top = AspectRatioUtil.calculateTop(left, right, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case RIGHT: {
                if (edge.equals((Object)TOP)) {
                    float top = imageRect.top;
                    float bottom = BOTTOM.getCoordinate() - offset;
                    float left = LEFT.getCoordinate();
                    float right = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)BOTTOM)) break;
                float bottom = imageRect.bottom;
                float top = TOP.getCoordinate() - offset;
                float left = LEFT.getCoordinate();
                float right = AspectRatioUtil.calculateRight(left, top, bottom, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            case BOTTOM: {
                if (edge.equals((Object)LEFT)) {
                    float left = imageRect.left;
                    float right = RIGHT.getCoordinate() - offset;
                    float top = TOP.getCoordinate();
                    float bottom = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                    return this.isOutOfBounds(top, left, bottom, right, imageRect);
                }
                if (!edge.equals((Object)RIGHT)) break;
                float right = imageRect.right;
                float left = LEFT.getCoordinate() - offset;
                float top = TOP.getCoordinate();
                float bottom = AspectRatioUtil.calculateBottom(left, top, right, aspectRatio);
                return this.isOutOfBounds(top, left, bottom, right, imageRect);
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
        return true;
    }

    private boolean isOutOfBounds(float top, float left, float bottom, float right, Rect imageRect) {
        return top < (float)imageRect.top || left < (float)imageRect.left || bottom > (float)imageRect.bottom || right > (float)imageRect.right;
    }

    public float snapToRect(Rect imageRect) {
        float oldCoordinate = this.mCoordinate;
        switch (this) {
            case LEFT: {
                this.mCoordinate = imageRect.left;
                break;
            }
            case TOP: {
                this.mCoordinate = imageRect.top;
                break;
            }
            case RIGHT: {
                this.mCoordinate = imageRect.right;
                break;
            }
            case BOTTOM: {
                this.mCoordinate = imageRect.bottom;
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
        return this.mCoordinate - oldCoordinate;
    }

    public float snapOffset(Rect imageRect) {
        float oldCoordinate;
        float newCoordinate = oldCoordinate = this.mCoordinate;
        switch (this) {
            case LEFT: {
                newCoordinate = imageRect.left;
                break;
            }
            case TOP: {
                newCoordinate = imageRect.top;
                break;
            }
            case RIGHT: {
                newCoordinate = imageRect.right;
                break;
            }
            case BOTTOM: {
                newCoordinate = imageRect.bottom;
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
        float offset = newCoordinate - oldCoordinate;
        return offset;
    }

    public void snapToView(View view) {
        switch (this) {
            case LEFT: {
                this.mCoordinate = 0.0f;
                break;
            }
            case TOP: {
                this.mCoordinate = 0.0f;
                break;
            }
            case RIGHT: {
                this.mCoordinate = view.getWidth();
                break;
            }
            case BOTTOM: {
                this.mCoordinate = view.getHeight();
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
    }

    public static float getWidth() {
        return RIGHT.getCoordinate() - LEFT.getCoordinate();
    }

    public static float getHeight() {
        return BOTTOM.getCoordinate() - TOP.getCoordinate();
    }

    public boolean isOutsideMargin(Rect rect, float margin) {
        boolean result = false;
        switch (this) {
            case LEFT: {
                result = this.mCoordinate - (float)rect.left < margin;
                break;
            }
            case TOP: {
                result = this.mCoordinate - (float)rect.top < margin;
                break;
            }
            case RIGHT: {
                result = (float)rect.right - this.mCoordinate < margin;
                break;
            }
            case BOTTOM: {
                result = (float)rect.bottom - this.mCoordinate < margin;
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
        return result;
    }

    public boolean isOutsideFrame(Rect rect) {
        double margin = 0.0;
        boolean result = false;
        switch (this) {
            case LEFT: {
                result = (double)(this.mCoordinate - (float)rect.left) < margin;
                break;
            }
            case TOP: {
                result = (double)(this.mCoordinate - (float)rect.top) < margin;
                break;
            }
            case RIGHT: {
                result = (double)((float)rect.right - this.mCoordinate) < margin;
                break;
            }
            case BOTTOM: {
                result = (double)((float)rect.bottom - this.mCoordinate) < margin;
                break;
            }
            default: {
                throw new InvalidParameterException("Unknown enum: " + (Object)((Object)this));
            }
        }
        return result;
    }

    private static float adjustLeft(float x, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float rx = x;
        if (rx - (float)imageRect.left < imageSnapRadius) {
            rx = imageRect.left;
        }
        if (RIGHT.getCoordinate() - rx < 60.0f) {
            rx = RIGHT.getCoordinate() - 60.0f;
        }
        if (aspectRatio > 0.0f && (RIGHT.getCoordinate() - rx) / aspectRatio < 60.0f) {
            rx = RIGHT.getCoordinate() - 60.0f * aspectRatio;
        }
        return rx;
    }

    private static float adjustRight(float x, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float rx = x;
        if ((float)imageRect.right - rx < imageSnapRadius) {
            rx = imageRect.right;
        }
        if (rx - LEFT.getCoordinate() < 60.0f) {
            rx = LEFT.getCoordinate() + 60.0f;
        }
        if (aspectRatio > 0.0f && (rx - LEFT.getCoordinate()) / aspectRatio < 60.0f) {
            rx = LEFT.getCoordinate() + 60.0f * aspectRatio;
        }
        return rx;
    }

    private static float adjustTop(float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float ry = y;
        if (ry - (float)imageRect.top < imageSnapRadius) {
            ry = imageRect.top;
        }
        if (BOTTOM.getCoordinate() - ry < 60.0f) {
            ry = BOTTOM.getCoordinate() - 60.0f;
        }
        if (aspectRatio > 0.0f && (BOTTOM.getCoordinate() - ry) * aspectRatio < 60.0f) {
            ry = BOTTOM.getCoordinate() - 60.0f / aspectRatio;
        }
        return ry;
    }

    private static float adjustBottom(float y, Rect imageRect, float imageSnapRadius, float aspectRatio) {
        float ry = y;
        if ((float)imageRect.bottom - ry < imageSnapRadius) {
            ry = imageRect.bottom;
        }
        if (ry - TOP.getCoordinate() < 60.0f) {
            ry = TOP.getCoordinate() + 60.0f;
        }
        if (aspectRatio > 0.0f && (ry - TOP.getCoordinate()) * aspectRatio < 60.0f) {
            ry = TOP.getCoordinate() + 60.0f / aspectRatio;
        }
        return ry;
    }
}

