/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.Defaults;
import com.theartofdev.edmodo.cropper.Edge;
import com.theartofdev.edmodo.cropper.HandleUtil;
import com.theartofdev.edmodo.cropper.cropwindow.handle.Handle;
import com.theartofdev.edmodo.cropper.util.AspectRatioUtil;

public class CropOverlayView
extends View {
    private Paint mBorderPaint;
    private Paint mBorderCornerPaint;
    private Paint mGuidelinePaint;
    private Paint mBackgroundPaint;
    private Rect mBitmapRect;
    private float mBorderCornerOffset;
    private float mBorderCornerLength;
    private float mHandleRadius;
    private float mSnapRadius;
    private Pair<Float, Float> mTouchOffset;
    private Handle mPressedHandle;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private float mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    private int mGuidelines = 1;
    private CropImageView.CropShape mCropShape;
    private boolean initializedCropWindow = false;
    private Integer mOriginalLayerType;

    public CropOverlayView(Context context) {
        this(context, null);
    }

    public CropOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setBitmapRect(Rect bitmapRect) {
        this.mBitmapRect = bitmapRect;
        this.initCropWindow(this.mBitmapRect);
    }

    public void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public CropImageView.CropShape getCropShape() {
        return this.mCropShape;
    }

    public void setCropShape(CropImageView.CropShape cropShape) {
        if (this.mCropShape != cropShape) {
            this.mCropShape = cropShape;
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 17) {
                if (this.mCropShape == CropImageView.CropShape.OVAL) {
                    this.mOriginalLayerType = this.getLayerType();
                    if (this.mOriginalLayerType != 1) {
                        this.setLayerType(1, null);
                    } else {
                        this.mOriginalLayerType = null;
                    }
                } else if (this.mOriginalLayerType != null) {
                    this.setLayerType(this.mOriginalLayerType, null);
                    this.mOriginalLayerType = null;
                }
            }
            this.invalidate();
        }
    }

    public void setGuidelines(int guidelines) {
        if (guidelines < 0 || guidelines > 2) {
            throw new IllegalArgumentException("Guideline value must be set between 0 and 2. See documentation.");
        }
        this.mGuidelines = guidelines;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mFixAspectRatio = fixAspectRatio;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioX(int aspectRatioX) {
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioX = aspectRatioX;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioY(int aspectRatioY) {
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioY = aspectRatioY;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setSnapRadius(float snapRadius) {
        this.mSnapRadius = TypedValue.applyDimension((int)1, (float)snapRadius, (DisplayMetrics)this.getResources().getDisplayMetrics());
    }

    public void setInitialAttributeValues(CropImageView.CropShape cropShape, float snapRadius, int guidelines, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY, float borderLineThickness, int borderLineColor, float borderCornerThickness, float borderCornerOffset, float borderCornerLength, int borderCornerColor, float guidelinesThickness, int guidelinesColor, int backgroundColor) {
        DisplayMetrics dm = this.getResources().getDisplayMetrics();
        this.setCropShape(cropShape);
        this.setSnapRadius(snapRadius);
        this.setGuidelines(guidelines);
        this.setFixedAspectRatio(fixAspectRatio);
        this.setAspectRatioX(aspectRatioX);
        this.setAspectRatioY(aspectRatioY);
        if (borderLineThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set line thickness value to a number less than 0.");
        }
        this.mBorderPaint = HandleUtil.getNewPaintOrNull(dm, borderLineThickness, borderLineColor);
        if (borderCornerThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set corner thickness value to a number less than 0.");
        }
        this.mBorderCornerOffset = TypedValue.applyDimension((int)1, (float)borderCornerOffset, (DisplayMetrics)dm);
        this.mBorderCornerLength = TypedValue.applyDimension((int)1, (float)borderCornerLength, (DisplayMetrics)dm);
        this.mBorderCornerPaint = HandleUtil.getNewPaintOrNull(dm, borderCornerThickness, borderCornerColor);
        if (guidelinesThickness < 0.0f) {
            throw new IllegalArgumentException("Cannot set guidelines thickness value to a number less than 0.");
        }
        this.mGuidelinePaint = HandleUtil.getNewPaintOrNull(dm, guidelinesThickness, guidelinesColor);
        this.mBackgroundPaint = HandleUtil.getNewPaint(backgroundColor);
        this.mHandleRadius = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)dm);
    }

    public static boolean showGuidelines() {
        return !(Math.abs(Edge.LEFT.getCoordinate() - Edge.RIGHT.getCoordinate()) < 100.0f) && !(Math.abs(Edge.TOP.getCoordinate() - Edge.BOTTOM.getCoordinate()) < 100.0f);
    }

    private void initCropWindow(Rect bitmapRect) {
        if (bitmapRect.width() == 0 || bitmapRect.height() == 0) {
            return;
        }
        this.initializedCropWindow = true;
        if (this.mFixAspectRatio && (bitmapRect.left != 0 || bitmapRect.right != 0 || bitmapRect.top != 0 || bitmapRect.bottom != 0)) {
            float bitmapAspectRatio = (float)bitmapRect.width() / (float)bitmapRect.height();
            if (bitmapAspectRatio > this.mTargetAspectRatio) {
                Edge.TOP.setCoordinate(bitmapRect.top);
                Edge.BOTTOM.setCoordinate(bitmapRect.bottom);
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float cropWidth = Math.max(60.0f, AspectRatioUtil.calculateWidth(Edge.TOP.getCoordinate(), Edge.BOTTOM.getCoordinate(), this.mTargetAspectRatio));
                if (cropWidth == 60.0f) {
                    this.mTargetAspectRatio = 60.0f / (Edge.BOTTOM.getCoordinate() - Edge.TOP.getCoordinate());
                }
                float halfCropWidth = cropWidth / 2.0f;
                Edge.LEFT.setCoordinate(centerX - halfCropWidth);
                Edge.RIGHT.setCoordinate(centerX + halfCropWidth);
            } else {
                Edge.LEFT.setCoordinate(bitmapRect.left);
                Edge.RIGHT.setCoordinate(bitmapRect.right);
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(60.0f, AspectRatioUtil.calculateHeight(Edge.LEFT.getCoordinate(), Edge.RIGHT.getCoordinate(), this.mTargetAspectRatio));
                if (cropHeight == 60.0f) {
                    this.mTargetAspectRatio = (Edge.RIGHT.getCoordinate() - Edge.LEFT.getCoordinate()) / 60.0f;
                }
                float halfCropHeight = cropHeight / 2.0f;
                Edge.TOP.setCoordinate(centerY - halfCropHeight);
                Edge.BOTTOM.setCoordinate(centerY + halfCropHeight);
            }
        } else {
            float horizontalPadding = 0.1f * (float)bitmapRect.width();
            float verticalPadding = 0.1f * (float)bitmapRect.height();
            Edge.LEFT.setCoordinate((float)bitmapRect.left + horizontalPadding);
            Edge.TOP.setCoordinate((float)bitmapRect.top + verticalPadding);
            Edge.RIGHT.setCoordinate((float)bitmapRect.right - horizontalPadding);
            Edge.BOTTOM.setCoordinate((float)bitmapRect.bottom - verticalPadding);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.initCropWindow(this.mBitmapRect);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas, this.mBitmapRect);
        if (CropOverlayView.showGuidelines()) {
            if (this.mGuidelines == 2) {
                this.drawGuidelines(canvas);
            } else if (this.mGuidelines == 1 && this.mPressedHandle != null) {
                this.drawGuidelines(canvas);
            }
        }
        this.drawBorders(canvas);
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            this.drawCorners(canvas);
        }
    }

    private void drawBackground(Canvas canvas, Rect bitmapRect) {
        float l = Edge.LEFT.getCoordinate();
        float t = Edge.TOP.getCoordinate();
        float r = Edge.RIGHT.getCoordinate();
        float b = Edge.BOTTOM.getCoordinate();
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, t, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, b, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, t, l, b, this.mBackgroundPaint);
            canvas.drawRect(r, t, (float)bitmapRect.right, b, this.mBackgroundPaint);
        } else {
            Path circleSelectionPath = new Path();
            if (Build.VERSION.SDK_INT >= 11 && Build.VERSION.SDK_INT <= 17 && this.mCropShape == CropImageView.CropShape.OVAL) {
                Defaults.EMPTY_RECT_F.set(l + 2.0f, t + 2.0f, r - 2.0f, b - 2.0f);
            } else {
                Defaults.EMPTY_RECT_F.set(l, t, r, b);
            }
            circleSelectionPath.addOval(Defaults.EMPTY_RECT_F, Path.Direction.CW);
            canvas.save();
            canvas.clipPath(circleSelectionPath, Region.Op.XOR);
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.restore();
        }
    }

    private void drawGuidelines(Canvas canvas) {
        if (this.mGuidelinePaint != null) {
            float sw = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            float l = Edge.LEFT.getCoordinate() + sw;
            float t = Edge.TOP.getCoordinate() + sw;
            float r = Edge.RIGHT.getCoordinate() - sw;
            float b = Edge.BOTTOM.getCoordinate() - sw;
            float oneThirdCropWidth = Edge.getWidth() / 3.0f;
            float oneThirdCropHeight = Edge.getHeight() / 3.0f;
            if (this.mCropShape == CropImageView.CropShape.OVAL) {
                float w = Edge.getWidth() / 2.0f - sw;
                float h = Edge.getHeight() / 2.0f - sw;
                float x1 = l + oneThirdCropWidth;
                float x2 = r - oneThirdCropWidth;
                float yv = (float)((double)h * Math.sin(Math.acos((w - oneThirdCropWidth) / w)));
                canvas.drawLine(x1, t + h - yv, x1, b - h + yv, this.mGuidelinePaint);
                canvas.drawLine(x2, t + h - yv, x2, b - h + yv, this.mGuidelinePaint);
                float y1 = t + oneThirdCropHeight;
                float y2 = b - oneThirdCropHeight;
                float xv = (float)((double)w * Math.cos(Math.asin((h - oneThirdCropHeight) / h)));
                canvas.drawLine(l + w - xv, y1, r - w + xv, y1, this.mGuidelinePaint);
                canvas.drawLine(l + w - xv, y2, r - w + xv, y2, this.mGuidelinePaint);
            } else {
                float x1 = l + oneThirdCropWidth;
                float x2 = r - oneThirdCropWidth;
                canvas.drawLine(x1, t, x1, b, this.mGuidelinePaint);
                canvas.drawLine(x2, t, x2, b, this.mGuidelinePaint);
                float y1 = t + oneThirdCropHeight;
                float y2 = b - oneThirdCropHeight;
                canvas.drawLine(l, y1, r, y1, this.mGuidelinePaint);
                canvas.drawLine(l, y2, r, y2, this.mGuidelinePaint);
            }
        }
    }

    private void drawBorders(Canvas canvas) {
        if (this.mBorderPaint != null) {
            float w = this.mBorderPaint.getStrokeWidth();
            float l = Edge.LEFT.getCoordinate() + w / 2.0f;
            float t = Edge.TOP.getCoordinate() + w / 2.0f;
            float r = Edge.RIGHT.getCoordinate() - w / 2.0f;
            float b = Edge.BOTTOM.getCoordinate() - w / 2.0f;
            if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
                canvas.drawRect(l, t, r, b, this.mBorderPaint);
            } else {
                Defaults.EMPTY_RECT_F.set(l, t, r, b);
                canvas.drawOval(Defaults.EMPTY_RECT_F, this.mBorderPaint);
            }
        }
    }

    private void drawCorners(Canvas canvas) {
        if (this.mBorderCornerPaint != null) {
            float lineWidth = this.mBorderPaint != null ? this.mBorderPaint.getStrokeWidth() : 0.0f;
            float cornerWidth = this.mBorderCornerPaint.getStrokeWidth();
            float w = cornerWidth / 2.0f + this.mBorderCornerOffset;
            float l = Edge.LEFT.getCoordinate() + w;
            float t = Edge.TOP.getCoordinate() + w;
            float r = Edge.RIGHT.getCoordinate() - w;
            float b = Edge.BOTTOM.getCoordinate() - w;
            float cornerOffset = (cornerWidth - lineWidth) / 2.0f;
            float cornerExtension = cornerWidth / 2.0f + cornerOffset;
            canvas.drawLine(l - cornerOffset, t - cornerExtension, l - cornerOffset, t + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(l - cornerExtension, t - cornerOffset, l + this.mBorderCornerLength, t - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(r + cornerOffset, t - cornerExtension, r + cornerOffset, t + this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(r + cornerExtension, t - cornerOffset, r - this.mBorderCornerLength, t - cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(l - cornerOffset, b + cornerExtension, l - cornerOffset, b - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(l - cornerExtension, b + cornerOffset, l + this.mBorderCornerLength, b + cornerOffset, this.mBorderCornerPaint);
            canvas.drawLine(r + cornerOffset, b + cornerExtension, r + cornerOffset, b - this.mBorderCornerLength, this.mBorderCornerPaint);
            canvas.drawLine(r + cornerExtension, b + cornerOffset, r - this.mBorderCornerLength, b + cornerOffset, this.mBorderCornerPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onActionDown(event.getX(), event.getY());
                return true;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onActionUp();
                return true;
            }
            case 2: {
                this.onActionMove(event.getX(), event.getY());
                this.getParent().requestDisallowInterceptTouchEvent(true);
                return true;
            }
        }
        return false;
    }

    private void onActionDown(float x, float y) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        this.mPressedHandle = HandleUtil.getPressedHandle(x, y, left, top, right, bottom, this.mHandleRadius, this.mCropShape);
        if (this.mPressedHandle == null) {
            return;
        }
        this.mTouchOffset = HandleUtil.getOffset(this.mPressedHandle, x, y, left, top, right, bottom);
        this.invalidate();
    }

    private void onActionUp() {
        if (this.mPressedHandle == null) {
            return;
        }
        this.mPressedHandle = null;
        this.invalidate();
    }

    private void onActionMove(float x, float y) {
        if (this.mPressedHandle == null) {
            return;
        }
        x += ((Float)this.mTouchOffset.first).floatValue();
        y += ((Float)this.mTouchOffset.second).floatValue();
        if (this.mFixAspectRatio) {
            this.mPressedHandle.updateCropWindow(x, y, this.mTargetAspectRatio, this.mBitmapRect, this.mSnapRadius);
        } else {
            this.mPressedHandle.updateCropWindow(x, y, this.mBitmapRect, this.mSnapRadius);
        }
        this.invalidate();
    }
}

