/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.AsyncTask;
import com.theartofdev.edmodo.cropper.BitmapUtil;
import com.theartofdev.edmodo.cropper.CropImageView;
import java.lang.ref.WeakReference;

class BitmapCroppingWorkerTask
extends AsyncTask<Void, Void, Result> {
    private final WeakReference<CropImageView> mCropImageViewReference;
    private final Bitmap mBitmap;
    private final Uri mUri;
    private final Context mContext;
    private final Rect mRect;
    private final CropImageView.CropShape mCropShape;
    private final int mDegreesRotated;
    private final int mReqWidth;
    private final int mReqHeight;

    public BitmapCroppingWorkerTask(CropImageView cropImageView, Bitmap bitmap, Rect rect, CropImageView.CropShape cropShape) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        this.mBitmap = bitmap;
        this.mRect = rect;
        this.mCropShape = cropShape;
        this.mUri = null;
        this.mDegreesRotated = 0;
        this.mReqWidth = 0;
        this.mReqHeight = 0;
    }

    public BitmapCroppingWorkerTask(CropImageView cropImageView, Uri uri, Rect rect, CropImageView.CropShape cropShape, int degreesRotated, int reqWidth, int reqHeight) {
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        this.mUri = uri;
        this.mRect = rect;
        this.mCropShape = cropShape;
        this.mDegreesRotated = degreesRotated;
        this.mReqWidth = reqWidth;
        this.mReqHeight = reqHeight;
        this.mBitmap = null;
    }

    public Uri getUri() {
        return this.mUri;
    }

    protected Result doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                Bitmap bitmap = null;
                if (this.mUri != null) {
                    bitmap = BitmapUtil.cropBitmap(this.mContext, this.mUri, this.mRect, this.mDegreesRotated, this.mReqWidth, this.mReqHeight);
                } else if (this.mBitmap != null) {
                    bitmap = BitmapUtil.cropBitmap(this.mBitmap, this.mRect);
                }
                if (bitmap != null && this.mCropShape == CropImageView.CropShape.OVAL) {
                    bitmap = BitmapUtil.toOvalBitmap(bitmap);
                }
                return new Result(bitmap);
            }
            return null;
        }
        catch (Exception e) {
            return new Result(e);
        }
    }

    protected void onPostExecute(Result result) {
        if (result != null) {
            CropImageView cropImageView;
            boolean completeCalled = false;
            if (!this.isCancelled() && (cropImageView = (CropImageView)((Object)this.mCropImageViewReference.get())) != null) {
                completeCalled = true;
                cropImageView.onGetImageCroppingAsyncComplete(result);
            }
            if (!completeCalled && result.bitmap != null) {
                result.bitmap.recycle();
            }
        }
    }

    public static final class Result {
        public final Bitmap bitmap;
        public final Exception error;

        Result(Bitmap bitmap) {
            this.bitmap = bitmap;
            this.error = null;
        }

        Result(Exception error) {
            this.bitmap = null;
            this.error = error;
        }
    }
}

