/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class ImageViewUtil {
    public static Rect getBitmapRect(Bitmap bitmap, View view, ImageView.ScaleType scaleType) {
        int bitmapWidth = bitmap.getWidth();
        int bitmapHeight = bitmap.getHeight();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        switch (scaleType) {
            default: {
                return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
            }
            case FIT_CENTER: 
        }
        return ImageViewUtil.getBitmapRectFitCenterHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static Rect getBitmapRect(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight, ImageView.ScaleType scaleType) {
        switch (scaleType) {
            default: {
                return ImageViewUtil.getBitmapRectCenterInsideHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
            }
            case FIT_CENTER: 
        }
        return ImageViewUtil.getBitmapRectFitCenterHelper(bitmapWidth, bitmapHeight, viewWidth, viewHeight);
    }

    public static RotateBitmapResult rotateBitmapByExif(Context context, Bitmap bitmap, Uri uri) {
        try {
            File file = ImageViewUtil.getFileFromUri(context, uri);
            if (file.exists()) {
                ExifInterface ei = new ExifInterface(file.getAbsolutePath());
                return ImageViewUtil.rotateBitmapByExif(bitmap, ei);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new RotateBitmapResult(bitmap, 0);
    }

    public static RotateBitmapResult rotateBitmapByExif(Bitmap bitmap, ExifInterface exif) {
        int degrees = 0;
        int orientation = exif.getAttributeInt("Orientation", 1);
        switch (orientation) {
            case 6: {
                degrees = 90;
                break;
            }
            case 3: {
                degrees = 180;
                break;
            }
            case 8: {
                degrees = 270;
            }
        }
        if (degrees > 0) {
            bitmap = ImageViewUtil.rotateBitmap(bitmap, degrees);
        }
        return new RotateBitmapResult(bitmap, degrees);
    }

    public static DecodeBitmapResult decodeSampledBitmap(Context context, Uri uri, int reqWidth, int reqHeight) {
        DecodeBitmapResult decodeBitmapResult;
        InputStream stream = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            stream = resolver.openInputStream(uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)stream, (Rect)new Rect(0, 0, 0, 0), (BitmapFactory.Options)options);
            options.inJustDecodeBounds = false;
            options.inSampleSize = ImageViewUtil.calculateInSampleSize(options.outWidth, options.outHeight, reqWidth, reqHeight);
            ImageViewUtil.closeSafe(stream);
            stream = resolver.openInputStream(uri);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)stream, (Rect)new Rect(0, 0, 0, 0), (BitmapFactory.Options)options);
            decodeBitmapResult = new DecodeBitmapResult(bitmap, options.inSampleSize);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to load sampled bitmap", e);
            }
            catch (Throwable throwable) {
                ImageViewUtil.closeSafe(stream);
                throw throwable;
            }
        }
        ImageViewUtil.closeSafe(stream);
        return decodeBitmapResult;
    }

    public static DecodeBitmapResult decodeSampledBitmapRegion(Context context, Uri uri, Rect rect, int reqWidth, int reqHeight) {
        DecodeBitmapResult decodeBitmapResult;
        InputStream stream = null;
        try {
            ContentResolver resolver = context.getContentResolver();
            stream = resolver.openInputStream(uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inSampleSize = ImageViewUtil.calculateInSampleSize(rect.width(), rect.height(), reqWidth, reqHeight);
            BitmapRegionDecoder decoder = BitmapRegionDecoder.newInstance((InputStream)stream, (boolean)false);
            Bitmap bitmap = decoder.decodeRegion(rect, options);
            decodeBitmapResult = new DecodeBitmapResult(bitmap, options.inSampleSize);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Failed to load sampled bitmap", e);
            }
            catch (Throwable throwable) {
                ImageViewUtil.closeSafe(stream);
                throw throwable;
            }
        }
        ImageViewUtil.closeSafe(stream);
        return decodeBitmapResult;
    }

    public static Bitmap cropBitmap(Context context, Uri loadedImageUri, Rect rect, int degreesRotated, int reqWidth, int reqHeight) {
        reqWidth = reqWidth > 0 ? reqWidth : rect.width();
        reqHeight = reqHeight > 0 ? reqHeight : rect.height();
        DecodeBitmapResult result = ImageViewUtil.decodeSampledBitmapRegion(context, loadedImageUri, rect, reqWidth, reqHeight);
        Bitmap bitmap = result.bitmap;
        if (degreesRotated > 0) {
            bitmap = ImageViewUtil.rotateBitmap(bitmap, degreesRotated);
        }
        return bitmap;
    }

    public static Bitmap cropBitmap(Bitmap bitmap, Rect rect) {
        return Bitmap.createBitmap((Bitmap)bitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
    }

    public static Bitmap toOvalBitmap(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        int color = -12434878;
        Paint paint = new Paint();
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(color);
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        canvas.drawOval(rect, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        bitmap.recycle();
        return output;
    }

    public static int calculateInSampleSize(int width, int height, int reqWidth, int reqHeight) {
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int halfHeight = height / 2;
            int halfWidth = width / 2;
            while (halfHeight / inSampleSize > reqHeight && halfWidth / inSampleSize > reqWidth) {
                inSampleSize *= 2;
            }
        }
        return inSampleSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getFileFromUri(Context context, Uri uri) {
        File file = new File(uri.getPath());
        if (file.exists()) {
            return file;
        }
        try (Cursor cursor = null;){
            String[] proj = new String[]{"_data"};
            cursor = context.getContentResolver().query(uri, proj, null, null, null);
            int column_index = cursor.getColumnIndexOrThrow("_data");
            cursor.moveToFirst();
            String realPath = cursor.getString(column_index);
            file = new File(realPath);
        }
        return file;
    }

    public static RotateBitmapResult rotateBitmapResult(Bitmap bitmap, int degrees) {
        return new RotateBitmapResult(ImageViewUtil.rotateBitmap(bitmap, degrees), degrees);
    }

    public static Bitmap rotateBitmap(Bitmap bitmap, int degrees) {
        if (degrees > 0) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)degrees);
            Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)false);
            bitmap.recycle();
            return newBitmap;
        }
        return bitmap;
    }

    public static void closeSafe(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static Rect getBitmapRectCenterInsideHelper(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        int resultY;
        int resultX;
        double resultHeight;
        double resultWidth;
        double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
        double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
        if (viewWidth < bitmapWidth) {
            viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        }
        if (viewHeight < bitmapHeight) {
            viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        }
        if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
            if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                resultWidth = viewWidth;
                resultHeight = (double)bitmapHeight * resultWidth / (double)bitmapWidth;
            } else {
                resultHeight = viewHeight;
                resultWidth = (double)bitmapWidth * resultHeight / (double)bitmapHeight;
            }
        } else {
            resultHeight = bitmapHeight;
            resultWidth = bitmapWidth;
        }
        if (resultWidth == (double)viewWidth) {
            resultX = 0;
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        } else if (resultHeight == (double)viewHeight) {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = 0;
        } else {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        }
        Rect result = new Rect(resultX, resultY, resultX + (int)Math.ceil(resultWidth), resultY + (int)Math.ceil(resultHeight));
        return result;
    }

    private static Rect getBitmapRectFitCenterHelper(int bitmapWidth, int bitmapHeight, int viewWidth, int viewHeight) {
        int resultY;
        int resultX;
        double resultHeight;
        double resultWidth;
        double viewToBitmapWidthRatio = (double)viewWidth / (double)bitmapWidth;
        double viewToBitmapHeightRatio = (double)viewHeight / (double)bitmapHeight;
        if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
            resultWidth = viewWidth;
            resultHeight = (double)bitmapHeight * resultWidth / (double)bitmapWidth;
        } else {
            resultHeight = viewHeight;
            resultWidth = (double)bitmapWidth * resultHeight / (double)bitmapHeight;
        }
        if (resultWidth == (double)viewWidth) {
            resultX = 0;
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        } else if (resultHeight == (double)viewHeight) {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = 0;
        } else {
            resultX = (int)Math.round(((double)viewWidth - resultWidth) / 2.0);
            resultY = (int)Math.round(((double)viewHeight - resultHeight) / 2.0);
        }
        Rect result = new Rect(resultX, resultY, resultX + (int)Math.ceil(resultWidth), resultY + (int)Math.ceil(resultHeight));
        return result;
    }

    public static final class RotateBitmapResult {
        public final Bitmap bitmap;
        public final int degrees;

        RotateBitmapResult(Bitmap bitmap, int degrees) {
            this.bitmap = bitmap;
            this.degrees = degrees;
        }
    }

    public static final class DecodeBitmapResult {
        public final Bitmap bitmap;
        public final int sampleSize;

        DecodeBitmapResult(Bitmap bitmap, int sampleSize) {
            this.sampleSize = sampleSize;
            this.bitmap = bitmap;
        }
    }
}

