/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.theartofdev.edmodo.cropper.BitmapCroppingWorkerTask;
import com.theartofdev.edmodo.cropper.BitmapLoadingWorkerTask;
import com.theartofdev.edmodo.cropper.CropOverlayView;
import com.theartofdev.edmodo.cropper.Defaults;
import com.theartofdev.edmodo.cropper.R;
import com.theartofdev.edmodo.cropper.cropwindow.edge.Edge;
import com.theartofdev.edmodo.cropper.util.ImageViewUtil;
import java.lang.ref.WeakReference;

public class CropImageView
extends FrameLayout {
    private final ImageView mImageView;
    private final CropOverlayView mCropOverlayView;
    private final ProgressBar mProgressBar;
    private Bitmap mBitmap;
    private int mDegreesRotated = 0;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mImageResource = 0;
    private boolean mShowProgressBar = true;
    private WeakReference<OnSetImageUriCompleteListener> mOnSetImageUriCompleteListener;
    private WeakReference<OnGetCroppedImageCompleteListener> mOnGetCroppedImageCompleteListener;
    private Uri mLoadedImageUri;
    private int mLoadedSampleSize = 1;
    private WeakReference<BitmapLoadingWorkerTask> mBitmapLoadingWorkerTask;
    private WeakReference<BitmapCroppingWorkerTask> mBitmapCroppingWorkerTask;

    public CropImageView(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int guidelines = 1;
        boolean fixAspectRatio = false;
        int aspectRatioX = 1;
        int aspectRatioY = 1;
        ImageView.ScaleType scaleType = Defaults.VALID_SCALE_TYPES[0];
        CropShape cropShape = CropShape.RECTANGLE;
        float snapRadius = 3.0f;
        if (attrs != null) {
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
            try {
                guidelines = ta.getInteger(R.styleable.CropImageView_guidelines, guidelines);
                fixAspectRatio = ta.getBoolean(R.styleable.CropImageView_fixAspectRatio, false);
                aspectRatioX = ta.getInteger(R.styleable.CropImageView_aspectRatioX, 1);
                aspectRatioY = ta.getInteger(R.styleable.CropImageView_aspectRatioY, 1);
                scaleType = Defaults.VALID_SCALE_TYPES[ta.getInt(R.styleable.CropImageView_scaleType, 0)];
                cropShape = Defaults.VALID_CROP_SHAPES[ta.getInt(R.styleable.CropImageView_cropShape, 0)];
                snapRadius = ta.getFloat(R.styleable.CropImageView_snapRadius, snapRadius);
                this.mShowProgressBar = ta.getBoolean(R.styleable.CropImageView_showProgressBar, this.mShowProgressBar);
            }
            finally {
                ta.recycle();
            }
        }
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.mImageView.setScaleType(scaleType);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setInitialAttributeValues(guidelines, fixAspectRatio, aspectRatioX, aspectRatioY);
        this.mCropOverlayView.setCropShape(cropShape);
        this.mCropOverlayView.setSnapRadius(snapRadius);
        this.mCropOverlayView.setVisibility(this.mBitmap != null ? 0 : 4);
        this.mProgressBar = (ProgressBar)v.findViewById(R.id.CropProgressBar);
        this.setProgressBarVisibility();
    }

    public ImageView.ScaleType getScaleType() {
        return this.mImageView.getScaleType();
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mImageView.setScaleType(scaleType);
    }

    public CropShape getCropShape() {
        return this.mCropOverlayView.getCropShape();
    }

    public void setCropShape(CropShape cropShape) {
        this.mCropOverlayView.setCropShape(cropShape);
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public void setGuidelines(int guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mCropOverlayView.setAspectRatioX(aspectRatioX);
        this.mCropOverlayView.setAspectRatioY(aspectRatioY);
    }

    public void setSnapRadius(float snapRadius) {
        if (snapRadius >= 0.0f) {
            this.mCropOverlayView.setSnapRadius(snapRadius);
        }
    }

    public boolean isShowProgressBar() {
        return this.mShowProgressBar;
    }

    public void setShowProgressBar(boolean showProgressBar) {
        this.mShowProgressBar = showProgressBar;
        this.setProgressBarVisibility();
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public Uri getImageUri() {
        return this.mLoadedImageUri;
    }

    public Rect getActualCropRect() {
        if (this.mBitmap != null) {
            Rect displayedImageRect = ImageViewUtil.getBitmapRect(this.mBitmap, (View)this.mImageView, this.mImageView.getScaleType());
            float actualImageWidth = this.mBitmap.getWidth();
            float displayedImageWidth = displayedImageRect.width();
            float scaleFactorWidth = actualImageWidth / displayedImageWidth;
            float actualImageHeight = this.mBitmap.getHeight();
            float displayedImageHeight = displayedImageRect.height();
            float scaleFactorHeight = actualImageHeight / displayedImageHeight;
            float displayedCropLeft = Edge.LEFT.getCoordinate() - (float)displayedImageRect.left;
            float displayedCropTop = Edge.TOP.getCoordinate() - (float)displayedImageRect.top;
            float displayedCropWidth = Edge.getWidth();
            float displayedCropHeight = Edge.getHeight();
            float actualCropLeft = displayedCropLeft * scaleFactorWidth;
            float actualCropTop = displayedCropTop * scaleFactorHeight;
            float actualCropRight = actualCropLeft + displayedCropWidth * scaleFactorWidth;
            float actualCropBottom = actualCropTop + displayedCropHeight * scaleFactorHeight;
            actualCropLeft = Math.max(0.0f, actualCropLeft);
            actualCropTop = Math.max(0.0f, actualCropTop);
            actualCropRight = Math.min((float)this.mBitmap.getWidth(), actualCropRight);
            actualCropBottom = Math.min((float)this.mBitmap.getHeight(), actualCropBottom);
            return new Rect((int)actualCropLeft, (int)actualCropTop, (int)actualCropRight, (int)actualCropBottom);
        }
        return null;
    }

    public Rect getActualCropRectNoRotation() {
        if (this.mBitmap != null) {
            Rect rect = this.getActualCropRect();
            int rotateSide = this.mDegreesRotated / 90;
            if (rotateSide == 1) {
                rect.set(rect.top, this.mBitmap.getWidth() - rect.right, rect.bottom, this.mBitmap.getWidth() - rect.left);
            } else if (rotateSide == 2) {
                rect.set(this.mBitmap.getWidth() - rect.right, this.mBitmap.getHeight() - rect.bottom, this.mBitmap.getWidth() - rect.left, this.mBitmap.getHeight() - rect.top);
            } else if (rotateSide == 3) {
                rect.set(this.mBitmap.getHeight() - rect.bottom, rect.left, this.mBitmap.getHeight() - rect.top, rect.right);
            }
            rect.set(rect.left * this.mLoadedSampleSize, rect.top * this.mLoadedSampleSize, rect.right * this.mLoadedSampleSize, rect.bottom * this.mLoadedSampleSize);
            return rect;
        }
        return null;
    }

    public Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        if (this.mBitmap != null) {
            if (this.mLoadedImageUri != null && this.mLoadedSampleSize > 1) {
                return ImageViewUtil.cropBitmap(this.getContext(), this.mLoadedImageUri, this.getActualCropRectNoRotation(), this.mDegreesRotated, reqWidth, reqHeight);
            }
            return ImageViewUtil.cropBitmap(this.mBitmap, this.getActualCropRect());
        }
        return null;
    }

    public Bitmap getCroppedOvalImage() {
        if (this.mBitmap != null) {
            Bitmap cropped = this.getCroppedImage();
            return ImageViewUtil.toOvalBitmap(cropped);
        }
        return null;
    }

    public void getCroppedImageAsync() {
        this.getCroppedImageAsync(CropShape.RECTANGLE, 0, 0);
    }

    public void getCroppedImageAsync(CropShape cropShape, int reqWidth, int reqHeight) {
        BitmapCroppingWorkerTask currentTask;
        if (this.mOnGetCroppedImageCompleteListener == null) {
            throw new IllegalArgumentException("OnGetCroppedImageCompleteListener is not set");
        }
        BitmapCroppingWorkerTask bitmapCroppingWorkerTask = currentTask = this.mBitmapCroppingWorkerTask != null ? (BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get()) : null;
        if (currentTask != null) {
            currentTask.cancel(true);
        }
        this.mBitmapCroppingWorkerTask = this.mLoadedImageUri != null && this.mLoadedSampleSize > 1 ? new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mLoadedImageUri, this.getActualCropRectNoRotation(), cropShape, this.mDegreesRotated, reqWidth, reqHeight)) : new WeakReference<BitmapCroppingWorkerTask>(new BitmapCroppingWorkerTask(this, this.mBitmap, this.getActualCropRect(), cropShape));
        ((BitmapCroppingWorkerTask)((Object)this.mBitmapCroppingWorkerTask.get())).execute(new Void[0]);
        this.setProgressBarVisibility();
    }

    public void setOnSetImageUriCompleteListener(OnSetImageUriCompleteListener listener) {
        this.mOnSetImageUriCompleteListener = listener != null ? new WeakReference<OnSetImageUriCompleteListener>(listener) : null;
    }

    public void setOnGetCroppedImageCompleteListener(OnGetCroppedImageCompleteListener listener) {
        this.mOnGetCroppedImageCompleteListener = listener != null ? new WeakReference<OnGetCroppedImageCompleteListener>(listener) : null;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setBitmap(bitmap, true);
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        if (bitmap != null && exif != null) {
            ImageViewUtil.RotateBitmapResult result = ImageViewUtil.rotateBitmapByExif(bitmap, exif);
            bitmap = result.bitmap;
            this.mDegreesRotated = result.degrees;
        }
        this.setBitmap(bitmap, true);
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setBitmap(bitmap, true);
            this.mImageResource = resId;
        }
    }

    @Deprecated
    public void setImageUri(Uri uri) {
        if (uri != null) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            double densityAdj = metrics.density > 1.0f ? (double)(1.0f / metrics.density) : 1.0;
            int width = (int)((double)metrics.widthPixels * densityAdj);
            int height = (int)((double)metrics.heightPixels * densityAdj);
            ImageViewUtil.DecodeBitmapResult decodeResult = ImageViewUtil.decodeSampledBitmap(this.getContext(), uri, width, height);
            ImageViewUtil.RotateBitmapResult rotateResult = ImageViewUtil.rotateBitmapByExif(this.getContext(), decodeResult.bitmap, uri);
            this.setBitmap(rotateResult.bitmap, true);
            this.mLoadedImageUri = uri;
            this.mLoadedSampleSize = decodeResult.sampleSize;
            this.mDegreesRotated = rotateResult.degrees;
        }
    }

    public void setImageUriAsync(Uri uri) {
        this.setImageUriAsync(uri, null);
    }

    public void clearImage() {
        this.clearImage(true);
    }

    public void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.setBitmap(bitmap, false);
            this.mDegreesRotated += degrees;
            this.mDegreesRotated %= 360;
        }
    }

    private void setImageUriAsync(Uri uri, Integer preSetRotation) {
        if (uri != null) {
            BitmapLoadingWorkerTask currentTask;
            BitmapLoadingWorkerTask bitmapLoadingWorkerTask = currentTask = this.mBitmapLoadingWorkerTask != null ? (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get()) : null;
            if (currentTask != null) {
                currentTask.cancel(true);
            }
            this.clearImage(true);
            this.mBitmapLoadingWorkerTask = new WeakReference<BitmapLoadingWorkerTask>(new BitmapLoadingWorkerTask(this, uri, preSetRotation));
            ((BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())).execute(new Void[0]);
            this.setProgressBarVisibility();
        }
    }

    void onSetImageUriAsyncComplete(BitmapLoadingWorkerTask.Result result) {
        OnSetImageUriCompleteListener listener;
        this.mBitmapLoadingWorkerTask = null;
        this.setProgressBarVisibility();
        if (result.error == null) {
            this.setBitmap(result.bitmap, true);
            this.mLoadedImageUri = result.uri;
            this.mLoadedSampleSize = result.loadSampleSize;
            this.mDegreesRotated = result.degreesRotated;
        }
        OnSetImageUriCompleteListener onSetImageUriCompleteListener = listener = this.mOnSetImageUriCompleteListener != null ? (OnSetImageUriCompleteListener)this.mOnSetImageUriCompleteListener.get() : null;
        if (listener != null) {
            listener.onSetImageUriComplete(this, result.uri, result.error);
        }
    }

    void onGetImageCroppingAsyncComplete(BitmapCroppingWorkerTask.Result result) {
        OnGetCroppedImageCompleteListener listener;
        this.mBitmapCroppingWorkerTask = null;
        this.setProgressBarVisibility();
        OnGetCroppedImageCompleteListener onGetCroppedImageCompleteListener = listener = this.mOnGetCroppedImageCompleteListener != null ? (OnGetCroppedImageCompleteListener)this.mOnGetCroppedImageCompleteListener.get() : null;
        if (listener != null) {
            listener.onGetCroppedImageComplete(this, result.bitmap, result.error);
        }
    }

    private void setBitmap(Bitmap bitmap, boolean clearFull) {
        if (this.mBitmap != bitmap) {
            this.clearImage(clearFull);
            this.mBitmap = bitmap;
            this.mImageView.setImageBitmap(this.mBitmap);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.resetCropOverlayView();
                this.mCropOverlayView.setVisibility(0);
            }
        }
    }

    private void clearImage(boolean full) {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.mLoadedImageUri != null)) {
            this.mBitmap.recycle();
            this.mBitmap = null;
        }
        if (full) {
            this.mImageResource = 0;
            this.mLoadedImageUri = null;
            this.mLoadedSampleSize = 1;
            this.mDegreesRotated = 0;
            this.mImageView.setImageBitmap(null);
            if (this.mCropOverlayView != null) {
                this.mCropOverlayView.setVisibility(4);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        BitmapLoadingWorkerTask task;
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putParcelable("LOADED_IMAGE_URI", (Parcelable)this.mLoadedImageUri);
        bundle.putInt("LOADED_IMAGE_RESOURCE", this.mImageResource);
        if (this.mLoadedImageUri == null && this.mImageResource < 1) {
            bundle.putParcelable("SET_BITMAP", (Parcelable)this.mBitmap);
        }
        if (this.mBitmapLoadingWorkerTask != null && (task = (BitmapLoadingWorkerTask)((Object)this.mBitmapLoadingWorkerTask.get())) != null) {
            bundle.putParcelable("LOADING_IMAGE_URI", (Parcelable)task.getUri());
        }
        bundle.putInt("DEGREES_ROTATED", this.mDegreesRotated);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            Bitmap bitmap = null;
            Uri uri = (Uri)bundle.getParcelable("LOADED_IMAGE_URI");
            if (uri != null) {
                this.setImageUriAsync(uri, bundle.getInt("DEGREES_ROTATED"));
            } else {
                int resId = bundle.getInt("LOADED_IMAGE_RESOURCE");
                if (resId > 0) {
                    this.setImageResource(resId);
                } else {
                    bitmap = (Bitmap)bundle.getParcelable("SET_BITMAP");
                    if (bitmap != null) {
                        this.setBitmap(bitmap, true);
                    } else {
                        uri = (Uri)bundle.getParcelable("LOADING_IMAGE_URI");
                        if (uri != null) {
                            this.setImageUriAsync(uri);
                        }
                    }
                }
            }
            this.mDegreesRotated = bundle.getInt("DEGREES_ROTATED");
            if (this.mBitmap != null && bitmap == null) {
                int tmpRotated = this.mDegreesRotated;
                this.rotateImage(this.mDegreesRotated);
                this.mDegreesRotated = tmpRotated;
            }
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mBitmap != null) {
            Rect bitmapRect = ImageViewUtil.getBitmapRect(this.mBitmap, (View)this, this.mImageView.getScaleType());
            this.mCropOverlayView.setBitmapRect(bitmapRect);
        } else {
            this.mCropOverlayView.setBitmapRect(Defaults.EMPTY_RECT);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            Rect bitmapRect = ImageViewUtil.getBitmapRect(this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mLayoutWidth, this.mLayoutHeight, this.mImageView.getScaleType());
            this.mCropOverlayView.setBitmapRect(bitmapRect);
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.mCropOverlayView.setBitmapRect(Defaults.EMPTY_RECT);
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origParams = this.getLayoutParams();
            origParams.width = this.mLayoutWidth;
            origParams.height = this.mLayoutHeight;
            this.setLayoutParams(origParams);
        }
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }

    private void setProgressBarVisibility() {
        boolean visible = this.mShowProgressBar && (this.mBitmap == null && this.mBitmapLoadingWorkerTask != null || this.mBitmapCroppingWorkerTask != null);
        this.mProgressBar.setVisibility(visible ? 0 : 4);
    }

    public static interface OnGetCroppedImageCompleteListener {
        public void onGetCroppedImageComplete(CropImageView var1, Bitmap var2, Exception var3);
    }

    public static interface OnSetImageUriCompleteListener {
        public void onSetImageUriComplete(CropImageView var1, Uri var2, Exception var3);
    }

    public static enum CropShape {
        RECTANGLE,
        OVAL;

    }
}

