/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.util.ImageViewUtil;
import java.lang.ref.WeakReference;

class BitmapLoadingWorkerTask
extends AsyncTask<Void, Void, Result> {
    private final WeakReference<CropImageView> mCropImageViewReference;
    private final Uri mUri;
    private final Integer mPreSetRotation;
    private final Context mContext;
    private final int mWidth;
    private final int mHeight;

    public BitmapLoadingWorkerTask(CropImageView cropImageView, Uri uri, Integer preSetRotation) {
        this.mUri = uri;
        this.mPreSetRotation = preSetRotation;
        this.mCropImageViewReference = new WeakReference<CropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        DisplayMetrics metrics = cropImageView.getResources().getDisplayMetrics();
        double densityAdj = metrics.density > 1.0f ? (double)(1.0f / metrics.density) : 1.0;
        this.mWidth = (int)((double)metrics.widthPixels * densityAdj);
        this.mHeight = (int)((double)metrics.heightPixels * densityAdj);
    }

    public Uri getUri() {
        return this.mUri;
    }

    protected Result doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                ImageViewUtil.DecodeBitmapResult decodeResult = ImageViewUtil.decodeSampledBitmap(this.mContext, this.mUri, this.mWidth, this.mHeight);
                if (!this.isCancelled()) {
                    ImageViewUtil.RotateBitmapResult rotateResult = this.mPreSetRotation != null ? ImageViewUtil.rotateBitmapResult(decodeResult.bitmap, this.mPreSetRotation) : ImageViewUtil.rotateBitmapByExif(this.mContext, decodeResult.bitmap, this.mUri);
                    return new Result(this.mUri, rotateResult.bitmap, decodeResult.sampleSize, rotateResult.degrees);
                }
            }
            return null;
        }
        catch (Exception e) {
            return new Result(this.mUri, e);
        }
    }

    protected void onPostExecute(Result result) {
        if (result != null) {
            CropImageView cropImageView;
            boolean completeCalled = false;
            if (!this.isCancelled() && (cropImageView = (CropImageView)((Object)this.mCropImageViewReference.get())) != null) {
                completeCalled = true;
                cropImageView.onSetImageUriAsyncComplete(result);
            }
            if (!completeCalled && result.bitmap != null) {
                result.bitmap.recycle();
            }
        }
    }

    public static final class Result {
        public final Uri uri;
        public final Bitmap bitmap;
        public final int loadSampleSize;
        public final int degreesRotated;
        public final Exception error;

        Result(Uri uri, Bitmap bitmap, int loadSampleSize, int degreesRotated) {
            this.uri = uri;
            this.bitmap = bitmap;
            this.loadSampleSize = loadSampleSize;
            this.degreesRotated = degreesRotated;
            this.error = null;
        }

        Result(Uri uri, Exception error) {
            this.uri = uri;
            this.bitmap = null;
            this.loadSampleSize = 0;
            this.degreesRotated = 0;
            this.error = error;
        }
    }
}

