/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper.util;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import com.theartofdev.edmodo.cropper.CropShape;
import com.theartofdev.edmodo.cropper.cropwindow.CropOverlayView;
import com.theartofdev.edmodo.cropper.cropwindow.handle.Handle;

public class HandleUtil {
    private static final int TARGET_RADIUS_DP = 24;

    public static float getTargetRadius(Context context) {
        float targetRadius = TypedValue.applyDimension((int)1, (float)24.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        return targetRadius;
    }

    public static Handle getPressedHandle(float x, float y, float left, float top, float right, float bottom, float targetRadius, CropShape cropShape) {
        Handle pressedHandle = null;
        if (cropShape == CropShape.RECTANGLE) {
            pressedHandle = HandleUtil.getRectanglePressedHandle(x, y, left, top, right, bottom, targetRadius);
        } else if (cropShape == CropShape.OVAL) {
            pressedHandle = HandleUtil.getOvalPressedHandle(x, y, left, top, right, bottom);
        }
        return pressedHandle;
    }

    private static Handle getRectanglePressedHandle(float x, float y, float left, float top, float right, float bottom, float targetRadius) {
        Handle pressedHandle = null;
        if (HandleUtil.isInCornerTargetZone(x, y, left, top, targetRadius)) {
            pressedHandle = Handle.TOP_LEFT;
        } else if (HandleUtil.isInCornerTargetZone(x, y, right, top, targetRadius)) {
            pressedHandle = Handle.TOP_RIGHT;
        } else if (HandleUtil.isInCornerTargetZone(x, y, left, bottom, targetRadius)) {
            pressedHandle = Handle.BOTTOM_LEFT;
        } else if (HandleUtil.isInCornerTargetZone(x, y, right, bottom, targetRadius)) {
            pressedHandle = Handle.BOTTOM_RIGHT;
        } else if (HandleUtil.isInCenterTargetZone(x, y, left, top, right, bottom) && HandleUtil.focusCenter()) {
            pressedHandle = Handle.CENTER;
        } else if (HandleUtil.isInHorizontalTargetZone(x, y, left, right, top, targetRadius)) {
            pressedHandle = Handle.TOP;
        } else if (HandleUtil.isInHorizontalTargetZone(x, y, left, right, bottom, targetRadius)) {
            pressedHandle = Handle.BOTTOM;
        } else if (HandleUtil.isInVerticalTargetZone(x, y, left, top, bottom, targetRadius)) {
            pressedHandle = Handle.LEFT;
        } else if (HandleUtil.isInVerticalTargetZone(x, y, right, top, bottom, targetRadius)) {
            pressedHandle = Handle.RIGHT;
        } else if (HandleUtil.isInCenterTargetZone(x, y, left, top, right, bottom) && !HandleUtil.focusCenter()) {
            pressedHandle = Handle.CENTER;
        }
        return pressedHandle;
    }

    private static Handle getOvalPressedHandle(float x, float y, float left, float top, float right, float bottom) {
        float cellLength = (right - left) / 6.0f;
        float leftCenter = left + cellLength;
        float rightCenter = left + 5.0f * cellLength;
        float cellHeight = (bottom - top) / 6.0f;
        float topCenter = top + cellHeight;
        float bottomCenter = top + 5.0f * cellHeight;
        Handle pressedHandle = x < leftCenter ? (y < topCenter ? Handle.TOP_LEFT : (y < bottomCenter ? Handle.LEFT : Handle.BOTTOM_LEFT)) : (x < rightCenter ? (y < topCenter ? Handle.TOP : (y < bottomCenter ? Handle.CENTER : Handle.BOTTOM)) : (y < topCenter ? Handle.TOP_RIGHT : (y < bottomCenter ? Handle.RIGHT : Handle.BOTTOM_RIGHT)));
        return pressedHandle;
    }

    public static Pair<Float, Float> getOffset(Handle handle, float x, float y, float left, float top, float right, float bottom) {
        if (handle == null) {
            return null;
        }
        float touchOffsetX = 0.0f;
        float touchOffsetY = 0.0f;
        switch (handle) {
            case TOP_LEFT: {
                touchOffsetX = left - x;
                touchOffsetY = top - y;
                break;
            }
            case TOP_RIGHT: {
                touchOffsetX = right - x;
                touchOffsetY = top - y;
                break;
            }
            case BOTTOM_LEFT: {
                touchOffsetX = left - x;
                touchOffsetY = bottom - y;
                break;
            }
            case BOTTOM_RIGHT: {
                touchOffsetX = right - x;
                touchOffsetY = bottom - y;
                break;
            }
            case LEFT: {
                touchOffsetX = left - x;
                touchOffsetY = 0.0f;
                break;
            }
            case TOP: {
                touchOffsetX = 0.0f;
                touchOffsetY = top - y;
                break;
            }
            case RIGHT: {
                touchOffsetX = right - x;
                touchOffsetY = 0.0f;
                break;
            }
            case BOTTOM: {
                touchOffsetX = 0.0f;
                touchOffsetY = bottom - y;
                break;
            }
            case CENTER: {
                float centerX = (right + left) / 2.0f;
                float centerY = (top + bottom) / 2.0f;
                touchOffsetX = centerX - x;
                touchOffsetY = centerY - y;
            }
        }
        Pair result = new Pair((Object)Float.valueOf(touchOffsetX), (Object)Float.valueOf(touchOffsetY));
        return result;
    }

    private static boolean isInCornerTargetZone(float x, float y, float handleX, float handleY, float targetRadius) {
        return Math.abs(x - handleX) <= targetRadius && Math.abs(y - handleY) <= targetRadius;
    }

    private static boolean isInHorizontalTargetZone(float x, float y, float handleXStart, float handleXEnd, float handleY, float targetRadius) {
        return x > handleXStart && x < handleXEnd && Math.abs(y - handleY) <= targetRadius;
    }

    private static boolean isInVerticalTargetZone(float x, float y, float handleX, float handleYStart, float handleYEnd, float targetRadius) {
        return Math.abs(x - handleX) <= targetRadius && y > handleYStart && y < handleYEnd;
    }

    private static boolean isInCenterTargetZone(float x, float y, float left, float top, float right, float bottom) {
        return x > left && x < right && y > top && y < bottom;
    }

    private static boolean focusCenter() {
        return !CropOverlayView.showGuidelines();
    }
}

