/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.edmodo.cropper.R;
import com.theartofdev.edmodo.cropper.cropwindow.CropOverlayView;
import com.theartofdev.edmodo.cropper.cropwindow.edge.Edge;
import com.theartofdev.edmodo.cropper.util.ImageViewUtil;

public class CropImageView
extends FrameLayout {
    private static final Rect EMPTY_RECT = new Rect();
    public static final int DEFAULT_GUIDELINES = 1;
    public static final boolean DEFAULT_FIXED_ASPECT_RATIO = false;
    public static final int DEFAULT_ASPECT_RATIO_X = 1;
    public static final int DEFAULT_ASPECT_RATIO_Y = 1;
    public static final int DEFAULT_SCALE_TYPE_INDEX = 0;
    public static final int DEFAULT_CROP_SHAPE_INDEX = 0;
    private static final int DEFAULT_IMAGE_RESOURCE = 0;
    private static final ImageView.ScaleType[] VALID_SCALE_TYPES = new ImageView.ScaleType[]{ImageView.ScaleType.CENTER_INSIDE, ImageView.ScaleType.FIT_CENTER};
    private static final CropShape[] VALID_CROP_SHAPES = new CropShape[]{CropShape.RECTANGLE, CropShape.OVAL};
    private static final String DEGREES_ROTATED = "DEGREES_ROTATED";
    private ImageView mImageView;
    private CropOverlayView mCropOverlayView;
    private Bitmap mBitmap;
    private int mDegreesRotated = 0;
    private int mLayoutWidth;
    private int mLayoutHeight;
    private int mGuidelines = 1;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private int mImageResource = 0;
    private ImageView.ScaleType mScaleType = VALID_SCALE_TYPES[0];
    private CropShape mCropShape;
    private Uri mLoadedImageUri;
    private int mLoadedSampleSize = 1;

    public CropImageView(Context context) {
        super(context);
        this.init(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CropImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.CropImageView, 0, 0);
        try {
            this.mGuidelines = ta.getInteger(R.styleable.CropImageView_guidelines, 1);
            this.mFixAspectRatio = ta.getBoolean(R.styleable.CropImageView_fixAspectRatio, false);
            this.mAspectRatioX = ta.getInteger(R.styleable.CropImageView_aspectRatioX, 1);
            this.mAspectRatioY = ta.getInteger(R.styleable.CropImageView_aspectRatioY, 1);
            this.mImageResource = ta.getResourceId(R.styleable.CropImageView_imageResource, 0);
            this.mScaleType = VALID_SCALE_TYPES[ta.getInt(R.styleable.CropImageView_scaleType, 0)];
            this.mCropShape = VALID_CROP_SHAPES[ta.getInt(R.styleable.CropImageView_cropShape, 0)];
        }
        finally {
            ta.recycle();
        }
        this.init(context);
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        this.mScaleType = scaleType;
        if (this.mImageView != null) {
            this.mImageView.setScaleType(this.mScaleType);
        }
    }

    public CropShape getCropShape() {
        return this.mCropShape;
    }

    public void setCropShape(CropShape cropShape) {
        if (cropShape != this.mCropShape) {
            this.mCropShape = cropShape;
            this.mCropOverlayView.setCropShape(cropShape);
        }
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mCropOverlayView.setFixedAspectRatio(fixAspectRatio);
    }

    public void setGuidelines(int guidelines) {
        this.mCropOverlayView.setGuidelines(guidelines);
    }

    public void setAspectRatio(int aspectRatioX, int aspectRatioY) {
        this.mAspectRatioX = aspectRatioX;
        this.mCropOverlayView.setAspectRatioX(this.mAspectRatioX);
        this.mAspectRatioY = aspectRatioY;
        this.mCropOverlayView.setAspectRatioY(this.mAspectRatioY);
    }

    public int getImageResource() {
        return this.mImageResource;
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (this.mBitmap != null && (this.mImageResource > 0 || this.mLoadedImageUri != null)) {
            this.mBitmap.recycle();
        }
        this.mImageResource = 0;
        this.mLoadedImageUri = null;
        this.mLoadedSampleSize = 1;
        this.mDegreesRotated = 0;
        this.mBitmap = bitmap;
        this.mImageView.setImageBitmap(this.mBitmap);
        if (this.mCropOverlayView != null) {
            this.mCropOverlayView.resetCropOverlayView();
        }
    }

    public void setImageBitmap(Bitmap bitmap, ExifInterface exif) {
        if (bitmap != null && exif != null) {
            ImageViewUtil.RotateBitmapResult result = ImageViewUtil.rotateBitmapByExif(bitmap, exif);
            bitmap = result.bitmap;
            this.mDegreesRotated = result.degrees;
        }
        this.setImageBitmap(bitmap);
    }

    public void setImageResource(int resId) {
        if (resId != 0) {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.setImageBitmap(bitmap);
            this.mImageResource = resId;
        }
    }

    public void setImageUri(Uri uri) {
        if (uri != null) {
            DisplayMetrics metrics = this.getResources().getDisplayMetrics();
            double densityAdj = metrics.density > 1.0f ? (double)(1.0f / metrics.density) : 1.0;
            int width = (int)((double)metrics.widthPixels * densityAdj);
            int height = (int)((double)metrics.heightPixels * densityAdj);
            ImageViewUtil.DecodeBitmapResult decodeResult = ImageViewUtil.decodeSampledBitmap(this.getContext(), uri, width, height);
            ImageViewUtil.RotateBitmapResult rotateResult = ImageViewUtil.rotateBitmapByExif(this.getContext(), decodeResult.bitmap, uri);
            this.setImageBitmap(rotateResult.bitmap);
            this.mLoadedImageUri = uri;
            this.mLoadedSampleSize = decodeResult.sampleSize;
            this.mDegreesRotated = rotateResult.degrees;
        }
    }

    public Rect getActualCropRect() {
        if (this.mBitmap != null) {
            Rect displayedImageRect = ImageViewUtil.getBitmapRect(this.mBitmap, (View)this.mImageView, this.mScaleType);
            float actualImageWidth = this.mBitmap.getWidth();
            float displayedImageWidth = displayedImageRect.width();
            float scaleFactorWidth = actualImageWidth / displayedImageWidth;
            float actualImageHeight = this.mBitmap.getHeight();
            float displayedImageHeight = displayedImageRect.height();
            float scaleFactorHeight = actualImageHeight / displayedImageHeight;
            float displayedCropLeft = Edge.LEFT.getCoordinate() - (float)displayedImageRect.left;
            float displayedCropTop = Edge.TOP.getCoordinate() - (float)displayedImageRect.top;
            float displayedCropWidth = Edge.getWidth();
            float displayedCropHeight = Edge.getHeight();
            float actualCropLeft = displayedCropLeft * scaleFactorWidth;
            float actualCropTop = displayedCropTop * scaleFactorHeight;
            float actualCropRight = actualCropLeft + displayedCropWidth * scaleFactorWidth;
            float actualCropBottom = actualCropTop + displayedCropHeight * scaleFactorHeight;
            actualCropLeft = Math.max(0.0f, actualCropLeft);
            actualCropTop = Math.max(0.0f, actualCropTop);
            actualCropRight = Math.min((float)this.mBitmap.getWidth(), actualCropRight);
            actualCropBottom = Math.min((float)this.mBitmap.getHeight(), actualCropBottom);
            return new Rect((int)actualCropLeft, (int)actualCropTop, (int)actualCropRight, (int)actualCropBottom);
        }
        return null;
    }

    public Rect getActualCropRectNoRotation() {
        if (this.mBitmap != null) {
            Rect rect = this.getActualCropRect();
            int rotateSide = this.mDegreesRotated / 90;
            if (rotateSide == 1) {
                rect.set(rect.top, this.mBitmap.getWidth() - rect.right, rect.bottom, this.mBitmap.getWidth() - rect.left);
            } else if (rotateSide == 2) {
                rect.set(this.mBitmap.getWidth() - rect.right, this.mBitmap.getHeight() - rect.bottom, this.mBitmap.getWidth() - rect.left, this.mBitmap.getHeight() - rect.top);
            } else if (rotateSide == 3) {
                rect.set(this.mBitmap.getHeight() - rect.bottom, rect.left, this.mBitmap.getHeight() - rect.top, rect.right);
            }
            rect.set(rect.left * this.mLoadedSampleSize, rect.top * this.mLoadedSampleSize, rect.right * this.mLoadedSampleSize, rect.bottom * this.mLoadedSampleSize);
            return rect;
        }
        return null;
    }

    public void rotateImage(int degrees) {
        if (this.mBitmap != null) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)degrees);
            this.mBitmap = Bitmap.createBitmap((Bitmap)this.mBitmap, (int)0, (int)0, (int)this.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Matrix)matrix, (boolean)true);
            this.setImageBitmap(this.mBitmap);
            this.mDegreesRotated += degrees;
            this.mDegreesRotated %= 360;
        }
    }

    public Bitmap getCroppedImage() {
        return this.getCroppedImage(0, 0);
    }

    public Bitmap getCroppedImage(int reqWidth, int reqHeight) {
        if (this.mBitmap != null) {
            if (this.mLoadedImageUri != null && this.mLoadedSampleSize > 1) {
                Rect rect = this.getActualCropRectNoRotation();
                reqWidth = reqWidth > 0 ? reqWidth : rect.width();
                reqHeight = reqHeight > 0 ? reqHeight : rect.height();
                ImageViewUtil.DecodeBitmapResult result = ImageViewUtil.decodeSampledBitmapRegion(this.getContext(), this.mLoadedImageUri, rect, reqWidth, reqHeight);
                Bitmap bitmap = result.bitmap;
                if (this.mDegreesRotated > 0) {
                    bitmap = ImageViewUtil.rotateBitmap(bitmap, this.mDegreesRotated);
                }
                return bitmap;
            }
            Rect rect = this.getActualCropRect();
            return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)rect.left, (int)rect.top, (int)rect.width(), (int)rect.height());
        }
        return null;
    }

    public Bitmap getCroppedOvalImage() {
        if (this.mBitmap != null) {
            Bitmap cropped = this.getCroppedImage();
            int width = cropped.getWidth();
            int height = cropped.getHeight();
            Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(output);
            int color = -12434878;
            Paint paint = new Paint();
            paint.setAntiAlias(true);
            canvas.drawARGB(0, 0, 0, 0);
            paint.setColor(-12434878);
            RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
            canvas.drawOval(rect, paint);
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
            canvas.drawBitmap(cropped, 0.0f, 0.0f, paint);
            return output;
        }
        return null;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("instanceState", super.onSaveInstanceState());
        bundle.putInt(DEGREES_ROTATED, this.mDegreesRotated);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            if (this.mBitmap != null) {
                int tempDegrees = this.mDegreesRotated = bundle.getInt(DEGREES_ROTATED);
                this.rotateImage(this.mDegreesRotated);
                this.mDegreesRotated = tempDegrees;
            }
            super.onRestoreInstanceState(bundle.getParcelable("instanceState"));
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        if (this.mBitmap != null) {
            Rect bitmapRect = ImageViewUtil.getBitmapRect(this.mBitmap, (View)this, this.mScaleType);
            this.mCropOverlayView.setBitmapRect(bitmapRect);
        } else {
            this.mCropOverlayView.setBitmapRect(EMPTY_RECT);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (this.mBitmap != null) {
            int desiredHeight;
            int desiredWidth;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (heightSize == 0) {
                heightSize = this.mBitmap.getHeight();
            }
            double viewToBitmapWidthRatio = Double.POSITIVE_INFINITY;
            double viewToBitmapHeightRatio = Double.POSITIVE_INFINITY;
            if (widthSize < this.mBitmap.getWidth()) {
                viewToBitmapWidthRatio = (double)widthSize / (double)this.mBitmap.getWidth();
            }
            if (heightSize < this.mBitmap.getHeight()) {
                viewToBitmapHeightRatio = (double)heightSize / (double)this.mBitmap.getHeight();
            }
            if (viewToBitmapWidthRatio != Double.POSITIVE_INFINITY || viewToBitmapHeightRatio != Double.POSITIVE_INFINITY) {
                if (viewToBitmapWidthRatio <= viewToBitmapHeightRatio) {
                    desiredWidth = widthSize;
                    desiredHeight = (int)((double)this.mBitmap.getHeight() * viewToBitmapWidthRatio);
                } else {
                    desiredHeight = heightSize;
                    desiredWidth = (int)((double)this.mBitmap.getWidth() * viewToBitmapHeightRatio);
                }
            } else {
                desiredWidth = this.mBitmap.getWidth();
                desiredHeight = this.mBitmap.getHeight();
            }
            int width = CropImageView.getOnMeasureSpec(widthMode, widthSize, desiredWidth);
            int height = CropImageView.getOnMeasureSpec(heightMode, heightSize, desiredHeight);
            this.mLayoutWidth = width;
            this.mLayoutHeight = height;
            Rect bitmapRect = ImageViewUtil.getBitmapRect(this.mBitmap.getWidth(), this.mBitmap.getHeight(), this.mLayoutWidth, this.mLayoutHeight, this.mScaleType);
            this.mCropOverlayView.setBitmapRect(bitmapRect);
            this.setMeasuredDimension(this.mLayoutWidth, this.mLayoutHeight);
        } else {
            this.mCropOverlayView.setBitmapRect(EMPTY_RECT);
            this.setMeasuredDimension(widthSize, heightSize);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.mLayoutWidth > 0 && this.mLayoutHeight > 0) {
            ViewGroup.LayoutParams origparams = this.getLayoutParams();
            origparams.width = this.mLayoutWidth;
            origparams.height = this.mLayoutHeight;
            this.setLayoutParams(origparams);
        }
    }

    private void init(Context context) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View v = inflater.inflate(R.layout.crop_image_view, (ViewGroup)this, true);
        this.mImageView = (ImageView)v.findViewById(R.id.ImageView_image);
        this.mImageView.setScaleType(this.mScaleType);
        this.setImageResource(this.mImageResource);
        this.mCropOverlayView = (CropOverlayView)v.findViewById(R.id.CropOverlayView);
        this.mCropOverlayView.setInitialAttributeValues(this.mGuidelines, this.mFixAspectRatio, this.mAspectRatioX, this.mAspectRatioY);
        this.mCropOverlayView.setCropShape(this.mCropShape);
    }

    private static int getOnMeasureSpec(int measureSpecMode, int measureSpecSize, int desiredSize) {
        int spec = measureSpecMode == 0x40000000 ? measureSpecSize : (measureSpecMode == Integer.MIN_VALUE ? Math.min(desiredSize, measureSpecSize) : desiredSize);
        return spec;
    }

    public static enum CropShape {
        RECTANGLE,
        OVAL;

    }
}

