/*
 * Decompiled with CFR 0.152.
 */
package com.theartofdev.edmodo.cropper.cropwindow;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Pair;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import com.theartofdev.edmodo.cropper.CropImageView;
import com.theartofdev.edmodo.cropper.cropwindow.edge.Edge;
import com.theartofdev.edmodo.cropper.cropwindow.handle.Handle;
import com.theartofdev.edmodo.cropper.util.AspectRatioUtil;
import com.theartofdev.edmodo.cropper.util.HandleUtil;
import com.theartofdev.edmodo.cropper.util.PaintUtil;

public class CropOverlayView
extends View {
    private static final int SNAP_RADIUS_DP = 6;
    private static final float DEFAULT_SHOW_GUIDELINES_LIMIT = 100.0f;
    private static final float DEFAULT_CORNER_THICKNESS_DP = PaintUtil.getCornerThickness();
    private static final float DEFAULT_LINE_THICKNESS_DP = PaintUtil.getLineThickness();
    private static final float DEFAULT_CORNER_OFFSET_DP = DEFAULT_CORNER_THICKNESS_DP / 2.0f - DEFAULT_LINE_THICKNESS_DP / 2.0f;
    private static final float DEFAULT_CORNER_EXTENSION_DP = DEFAULT_CORNER_THICKNESS_DP / 2.0f + DEFAULT_CORNER_OFFSET_DP;
    private static final float DEFAULT_CORNER_LENGTH_DP = 20.0f;
    private static final int GUIDELINES_ON_TOUCH = 1;
    private static final int GUIDELINES_ON = 2;
    private static RectF mRectF = new RectF();
    private Paint mBorderPaint;
    private Paint mGuidelinePaint;
    private Paint mCornerPaint;
    private Paint mBackgroundPaint;
    private Rect mBitmapRect;
    private float mHandleRadius;
    private float mSnapRadius;
    private Pair<Float, Float> mTouchOffset;
    private Handle mPressedHandle;
    private boolean mFixAspectRatio = false;
    private int mAspectRatioX = 1;
    private int mAspectRatioY = 1;
    private float mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    private int mGuidelines;
    private CropImageView.CropShape mCropShape;
    private boolean initializedCropWindow = false;
    private float mCornerExtension;
    private float mCornerOffset;
    private float mCornerLength;

    public CropOverlayView(Context context) {
        super(context);
        this.init(context);
    }

    public CropOverlayView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void setBitmapRect(Rect bitmapRect) {
        this.mBitmapRect = bitmapRect;
        this.initCropWindow(this.mBitmapRect);
    }

    public void resetCropOverlayView() {
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setCropShape(CropImageView.CropShape cropShape) {
        this.mCropShape = cropShape;
        this.invalidate();
    }

    public void setGuidelines(int guidelines) {
        if (guidelines < 0 || guidelines > 2) {
            throw new IllegalArgumentException("Guideline value must be set between 0 and 2. See documentation.");
        }
        this.mGuidelines = guidelines;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setFixedAspectRatio(boolean fixAspectRatio) {
        this.mFixAspectRatio = fixAspectRatio;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioX(int aspectRatioX) {
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioX = aspectRatioX;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setAspectRatioY(int aspectRatioY) {
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioY = aspectRatioY;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (this.initializedCropWindow) {
            this.initCropWindow(this.mBitmapRect);
            this.invalidate();
        }
    }

    public void setInitialAttributeValues(int guidelines, boolean fixAspectRatio, int aspectRatioX, int aspectRatioY) {
        if (guidelines < 0 || guidelines > 2) {
            throw new IllegalArgumentException("Guideline value must be set between 0 and 2. See documentation.");
        }
        this.mGuidelines = guidelines;
        this.mFixAspectRatio = fixAspectRatio;
        if (aspectRatioX <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioX = aspectRatioX;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
        if (aspectRatioY <= 0) {
            throw new IllegalArgumentException("Cannot set aspect ratio value to a number less than or equal to 0.");
        }
        this.mAspectRatioY = aspectRatioY;
        this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.initCropWindow(this.mBitmapRect);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawBackground(canvas, this.mBitmapRect);
        if (CropOverlayView.showGuidelines()) {
            if (this.mGuidelines == 2) {
                this.drawRuleOfThirdsGuidelines(canvas);
            } else if (this.mGuidelines == 1 && this.mPressedHandle != null) {
                this.drawRuleOfThirdsGuidelines(canvas);
            }
        }
        float w = this.mBorderPaint.getStrokeWidth();
        float l = Edge.LEFT.getCoordinate() + w;
        float t = Edge.TOP.getCoordinate() + w;
        float r = Edge.RIGHT.getCoordinate() - w;
        float b = Edge.BOTTOM.getCoordinate() - w;
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            canvas.drawRect(l, t, r, b, this.mBorderPaint);
            this.drawCorners(canvas);
        } else {
            mRectF.set(l, t, r, b);
            canvas.drawOval(mRectF, this.mBorderPaint);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.onActionDown(event.getX(), event.getY());
                return true;
            }
            case 1: 
            case 3: {
                this.getParent().requestDisallowInterceptTouchEvent(false);
                this.onActionUp();
                return true;
            }
            case 2: {
                this.onActionMove(event.getX(), event.getY());
                this.getParent().requestDisallowInterceptTouchEvent(true);
                return true;
            }
        }
        return false;
    }

    private void init(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mHandleRadius = HandleUtil.getTargetRadius(context);
        this.mSnapRadius = TypedValue.applyDimension((int)1, (float)6.0f, (DisplayMetrics)displayMetrics);
        this.mBorderPaint = PaintUtil.newBorderPaint(context);
        this.mGuidelinePaint = PaintUtil.newGuidelinePaint();
        this.mBackgroundPaint = PaintUtil.newBackgroundPaint(context);
        this.mCornerPaint = PaintUtil.newCornerPaint(context);
        this.mCornerOffset = TypedValue.applyDimension((int)1, (float)DEFAULT_CORNER_OFFSET_DP, (DisplayMetrics)displayMetrics);
        this.mCornerExtension = TypedValue.applyDimension((int)1, (float)DEFAULT_CORNER_EXTENSION_DP, (DisplayMetrics)displayMetrics);
        this.mCornerLength = TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)displayMetrics);
        this.mGuidelines = 1;
    }

    private void initCropWindow(Rect bitmapRect) {
        if (bitmapRect.width() == 0 || bitmapRect.height() == 0) {
            return;
        }
        if (!this.initializedCropWindow) {
            this.initializedCropWindow = true;
        }
        if (this.mFixAspectRatio && (bitmapRect.left != 0 || bitmapRect.right != 0 || bitmapRect.top != 0 || bitmapRect.bottom != 0)) {
            if (AspectRatioUtil.calculateAspectRatio(bitmapRect) > this.mTargetAspectRatio) {
                Edge.TOP.setCoordinate(bitmapRect.top);
                Edge.BOTTOM.setCoordinate(bitmapRect.bottom);
                float centerX = (float)this.getWidth() / 2.0f;
                this.mTargetAspectRatio = (float)this.mAspectRatioX / (float)this.mAspectRatioY;
                float cropWidth = Math.max(40.0f, AspectRatioUtil.calculateWidth(Edge.TOP.getCoordinate(), Edge.BOTTOM.getCoordinate(), this.mTargetAspectRatio));
                if (cropWidth == 40.0f) {
                    this.mTargetAspectRatio = 40.0f / (Edge.BOTTOM.getCoordinate() - Edge.TOP.getCoordinate());
                }
                float halfCropWidth = cropWidth / 2.0f;
                Edge.LEFT.setCoordinate(centerX - halfCropWidth);
                Edge.RIGHT.setCoordinate(centerX + halfCropWidth);
            } else {
                Edge.LEFT.setCoordinate(bitmapRect.left);
                Edge.RIGHT.setCoordinate(bitmapRect.right);
                float centerY = (float)this.getHeight() / 2.0f;
                float cropHeight = Math.max(40.0f, AspectRatioUtil.calculateHeight(Edge.LEFT.getCoordinate(), Edge.RIGHT.getCoordinate(), this.mTargetAspectRatio));
                if (cropHeight == 40.0f) {
                    this.mTargetAspectRatio = (Edge.RIGHT.getCoordinate() - Edge.LEFT.getCoordinate()) / 40.0f;
                }
                float halfCropHeight = cropHeight / 2.0f;
                Edge.TOP.setCoordinate(centerY - halfCropHeight);
                Edge.BOTTOM.setCoordinate(centerY + halfCropHeight);
            }
        } else {
            float horizontalPadding = 0.1f * (float)bitmapRect.width();
            float verticalPadding = 0.1f * (float)bitmapRect.height();
            Edge.LEFT.setCoordinate((float)bitmapRect.left + horizontalPadding);
            Edge.TOP.setCoordinate((float)bitmapRect.top + verticalPadding);
            Edge.RIGHT.setCoordinate((float)bitmapRect.right - horizontalPadding);
            Edge.BOTTOM.setCoordinate((float)bitmapRect.bottom - verticalPadding);
        }
    }

    public static boolean showGuidelines() {
        return !(Math.abs(Edge.LEFT.getCoordinate() - Edge.RIGHT.getCoordinate()) < 100.0f) && !(Math.abs(Edge.TOP.getCoordinate() - Edge.BOTTOM.getCoordinate()) < 100.0f);
    }

    private void drawRuleOfThirdsGuidelines(Canvas canvas) {
        float w = this.mBorderPaint.getStrokeWidth();
        float l = Edge.LEFT.getCoordinate() + w;
        float t = Edge.TOP.getCoordinate() + w;
        float r = Edge.RIGHT.getCoordinate() - w;
        float b = Edge.BOTTOM.getCoordinate() - w;
        if (this.mCropShape == CropImageView.CropShape.OVAL) {
            l += 15.0f * this.mGuidelinePaint.getStrokeWidth();
            t += 15.0f * this.mGuidelinePaint.getStrokeWidth();
            r -= 15.0f * this.mGuidelinePaint.getStrokeWidth();
            b -= 15.0f * this.mGuidelinePaint.getStrokeWidth();
        }
        float oneThirdCropWidth = Edge.getWidth() / 3.0f;
        float x1 = l + oneThirdCropWidth;
        canvas.drawLine(x1, t, x1, b, this.mGuidelinePaint);
        float x2 = r - oneThirdCropWidth;
        canvas.drawLine(x2, t, x2, b, this.mGuidelinePaint);
        float oneThirdCropHeight = Edge.getHeight() / 3.0f;
        float y1 = t + oneThirdCropHeight;
        canvas.drawLine(l, y1, r, y1, this.mGuidelinePaint);
        float y2 = b - oneThirdCropHeight;
        canvas.drawLine(l, y2, r, y2, this.mGuidelinePaint);
    }

    private void drawBackground(Canvas canvas, Rect bitmapRect) {
        float l = Edge.LEFT.getCoordinate();
        float t = Edge.TOP.getCoordinate();
        float r = Edge.RIGHT.getCoordinate();
        float b = Edge.BOTTOM.getCoordinate();
        if (this.mCropShape == CropImageView.CropShape.RECTANGLE) {
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, t, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, b, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.drawRect((float)bitmapRect.left, t, l, b, this.mBackgroundPaint);
            canvas.drawRect(r, t, (float)bitmapRect.right, b, this.mBackgroundPaint);
        } else {
            Path circleSelectionPath = new Path();
            mRectF.set(l, t, r, b);
            circleSelectionPath.addOval(mRectF, Path.Direction.CW);
            canvas.clipPath(circleSelectionPath, Region.Op.XOR);
            canvas.drawRect((float)bitmapRect.left, (float)bitmapRect.top, (float)bitmapRect.right, (float)bitmapRect.bottom, this.mBackgroundPaint);
            canvas.restore();
        }
    }

    private void drawCorners(Canvas canvas) {
        float w = this.mBorderPaint.getStrokeWidth();
        float l = Edge.LEFT.getCoordinate() + w;
        float t = Edge.TOP.getCoordinate() + w;
        float r = Edge.RIGHT.getCoordinate() - w;
        float b = Edge.BOTTOM.getCoordinate() - w;
        canvas.drawLine(l - this.mCornerOffset, t - this.mCornerExtension, l - this.mCornerOffset, t + this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(l, t - this.mCornerOffset, l + this.mCornerLength, t - this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(r + this.mCornerOffset, t - this.mCornerExtension, r + this.mCornerOffset, t + this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(r, t - this.mCornerOffset, r - this.mCornerLength, t - this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(l - this.mCornerOffset, b + this.mCornerExtension, l - this.mCornerOffset, b - this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(l, b + this.mCornerOffset, l + this.mCornerLength, b + this.mCornerOffset, this.mCornerPaint);
        canvas.drawLine(r + this.mCornerOffset, b + this.mCornerExtension, r + this.mCornerOffset, b - this.mCornerLength, this.mCornerPaint);
        canvas.drawLine(r, b + this.mCornerOffset, r - this.mCornerLength, b + this.mCornerOffset, this.mCornerPaint);
    }

    private void onActionDown(float x, float y) {
        float left = Edge.LEFT.getCoordinate();
        float top = Edge.TOP.getCoordinate();
        float right = Edge.RIGHT.getCoordinate();
        float bottom = Edge.BOTTOM.getCoordinate();
        this.mPressedHandle = HandleUtil.getPressedHandle(x, y, left, top, right, bottom, this.mHandleRadius);
        if (this.mPressedHandle == null) {
            return;
        }
        this.mTouchOffset = HandleUtil.getOffset(this.mPressedHandle, x, y, left, top, right, bottom);
        this.invalidate();
    }

    private void onActionUp() {
        if (this.mPressedHandle == null) {
            return;
        }
        this.mPressedHandle = null;
        this.invalidate();
    }

    private void onActionMove(float x, float y) {
        if (this.mPressedHandle == null) {
            return;
        }
        x += ((Float)this.mTouchOffset.first).floatValue();
        y += ((Float)this.mTouchOffset.second).floatValue();
        if (this.mFixAspectRatio) {
            this.mPressedHandle.updateCropWindow(x, y, this.mTargetAspectRatio, this.mBitmapRect, this.mSnapRadius);
        } else {
            this.mPressedHandle.updateCropWindow(x, y, this.mBitmapRect, this.mSnapRadius);
        }
        this.invalidate();
    }
}

