package com.theapache64.twinkill.network.utils.retrofit.adapters.flow


import com.theapache64.twinkill.network.utils.Resource
import kotlinx.coroutines.flow.Flow
import retrofit2.CallAdapter
import retrofit2.CallAdapter.Factory
import retrofit2.Retrofit
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type

class FlowResourceCallAdapterFactory(
    private val isNeedDeepCheck: Boolean = false,
    private val isSelfExceptionHandling: Boolean = true
) : Factory() {
    override fun get(
        returnType: Type,
        annotations: Array<Annotation>,
        retrofit: Retrofit
    ): CallAdapter<*, *>? {
        if (getRawType(returnType) != Flow::class.java) {
            return null
        }
        val observableType = getParameterUpperBound(0, returnType as ParameterizedType)
        val rawObservableType = getRawType(observableType)
        require(rawObservableType == Resource::class.java) { "type must be a resource" }
        require(observableType is ParameterizedType) { "resource must be parameterized" }
        val bodyType = getParameterUpperBound(0, observableType)
        return FlowResourceCallAdapter<Any>(bodyType, isNeedDeepCheck, isSelfExceptionHandling)
    }
}