/*
 * Decompiled with CFR 0.152.
 */
package com.theapache64.twinkill.ui.widgets;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.theapache64.twinkill.databinding.LoadingViewBinding;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\n2\b\b\u0001\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\n2\b\b\u0001\u0010\u0012\u001a\u00020\rJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\n2\b\b\u0001\u0010\u0014\u001a\u00020\rJ\u000e\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/theapache64/twinkill/ui/widgets/LoadingView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "binding", "Lcom/theapache64/twinkill/databinding/LoadingViewBinding;", "hideLoading", "", "setErrorRes", "drawable", "", "setRetryCallback", "retryCallback", "Lcom/theapache64/twinkill/ui/widgets/LoadingView$RetryCallback;", "setTextColor", "color", "showError", "message", "", "showLoading", "RetryCallback", "core_release"})
public final class LoadingView
extends FrameLayout {
    private final LoadingViewBinding binding;

    public final void setRetryCallback(@NotNull RetryCallback retryCallback) {
        Intrinsics.checkParameterIsNotNull((Object)retryCallback, (String)"retryCallback");
        this.binding.setRetryCallback(retryCallback);
    }

    public final void showLoading(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.setVisibility(0);
        this.binding.setIsLoading(true);
        this.binding.setIsError(false);
        this.binding.setMessage(message);
    }

    public final void showLoading(@StringRes int message) {
        String string2 = this.getContext().getString(message);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(message)");
        this.showLoading(string2);
    }

    public final void hideLoading() {
        this.setVisibility(8);
        this.binding.setIsLoading(false);
        this.binding.setIsError(false);
        this.binding.setMessage(null);
    }

    public final void showError(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.setVisibility(0);
        this.binding.setIsError(true);
        this.binding.setIsLoading(false);
        this.binding.setMessage(message);
    }

    public final void setTextColor(@ColorRes int color) {
        this.binding.tvMessage.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)color));
    }

    public final void setErrorRes(@DrawableRes int drawable) {
        this.binding.ivError.setImageResource(drawable);
    }

    public LoadingView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs);
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        LoadingViewBinding loadingViewBinding = LoadingViewBinding.inflate(inflater, (ViewGroup)this, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)loadingViewBinding), (String)"LoadingViewBinding.inflate(inflater, this, true)");
        this.binding = loadingViewBinding;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/theapache64/twinkill/ui/widgets/LoadingView$RetryCallback;", "", "onRetryClicked", "", "core_release"})
    public static interface RetryCallback {
        public void onRetryClicked();
    }
}

