/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.sourcemonitor;

import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorBuildAction;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorParser;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorProjectAction;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorReport;
import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorResult;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMonitorPublisher
extends Recorder
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String summaryFilePath;

    @DataBoundConstructor
    public SourceMonitorPublisher(String summaryFilePath) {
        this.summaryFilePath = summaryFilePath;
    }

    public Action getProjectAction(AbstractProject<?, ?> project) {
        return new SourceMonitorProjectAction(project);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.BUILD;
    }

    protected boolean canContinue(Result result) {
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        if (this.canContinue(build.getResult())) {
            SourceMonitorReport report;
            listener.getLogger().println("Parsing sourcemonitor results");
            FilePath workspace = build.getWorkspace();
            PrintStream logger = listener.getLogger();
            SourceMonitorParser parser = new SourceMonitorParser(new FilePath(build.getWorkspace(), this.summaryFilePath));
            try {
                report = (SourceMonitorReport)workspace.act((FilePath.FileCallable)parser);
            }
            catch (IOException ioe) {
                ioe.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace(logger);
                build.setResult(Result.FAILURE);
                return false;
            }
            SourceMonitorResult result = new SourceMonitorResult(report, build);
            SourceMonitorBuildAction buildAction = new SourceMonitorBuildAction(build, result);
            build.addAction((Action)buildAction);
            listener.getLogger().println("End Processing sourcemonitor results");
        }
        return true;
    }

    public String getSummaryFilePath() {
        return this.summaryFilePath;
    }
}

