/*
 * Decompiled with CFR 0.152.
 */
package com.thalesgroup.hudson.plugins.sourcemonitor;

import com.thalesgroup.hudson.plugins.sourcemonitor.SourceMonitorReport;
import hudson.AbortException;
import hudson.FilePath;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceMonitorParser
implements FilePath.FileCallable<SourceMonitorReport> {
    private static final long serialVersionUID = 1L;
    private FilePath resultFilePath;
    private static final Logger LOGGER = Logger.getLogger(SourceMonitorParser.class.getName());

    public SourceMonitorParser() {
        this.resultFilePath = null;
    }

    public SourceMonitorParser(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }

    public SourceMonitorReport invoke(File workspace, VirtualChannel channel) throws IOException {
        SourceMonitorReport sourceMonitorReport = new SourceMonitorReport();
        Document document = null;
        try {
            SAXBuilder sxb = new SAXBuilder();
            document = sxb.build((Reader)new InputStreamReader((InputStream)new FileInputStream(new File(this.resultFilePath.toURI())), "UTF-8"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Parsing file error :" + e.toString());
            throw new AbortException("Parsing file error");
        }
        ArrayList<Map<String, String>> metricsCheckpointList = new ArrayList<Map<String, String>>();
        Element root = document.getRootElement();
        Element projectElt = root.getChild("project");
        Element checkpoints = projectElt.getChild("checkpoints");
        List checkpointsEltList = checkpoints.getChildren();
        for (int i = 0; i < checkpointsEltList.size(); ++i) {
            Element checkpoint = (Element)checkpointsEltList.get(i);
            Element metricsElt = checkpoint.getChild("metrics");
            List metricsEltList = metricsElt.getChildren();
            HashMap<String, String> checkpointMap = new HashMap<String, String>();
            for (int j = 0; j < metricsEltList.size(); ++j) {
                Element metricElt = (Element)metricsEltList.get(j);
                checkpointMap.put(metricElt.getAttributeValue("id"), metricElt.getValue());
            }
            metricsCheckpointList.add(checkpointMap);
        }
        sourceMonitorReport.setCheckpoints(metricsCheckpointList);
        return sourceMonitorReport;
    }

    public FilePath getResultFilePath() {
        return this.resultFilePath;
    }

    public void setResultFilePath(FilePath resultFilePath) {
        this.resultFilePath = resultFilePath;
    }
}

