/*
 * Decompiled with CFR 0.152.
 */
package com.testfairy.modules.crash;

import android.util.Log;
import java.util.Stack;

public class NativeCrashHandler {
    public static final int OK = 0;
    public static final int ALREADY_INITIALIZED = 1;
    public static final int ERROR_DURING_SIGNAL_HANDLER = 2;
    public static Object delegate;
    public static boolean loaded = false;
    public static String TAG = "TESTFAIRYSDK";

    public static void loadNativeLibrary() {
        if (loaded) {
            return;
        }
        Log.d((String)TAG, (String)"Loading native lib");
        System.loadLibrary("testfairy-lib");
        Log.d((String)TAG, (String)"Loaded native lib");
        loaded = true;
    }

    public static void logInitializationResult(int n) {
        if (n != 0) {
            if (n != 1) {
                if (n == 2) {
                    Log.e((String)TAG, (String)"Native crash handler couldn't be initialized due to invalid signal handler.");
                }
            } else {
                Log.w((String)TAG, (String)"Native crash handler can't be initialized twice.");
            }
        } else {
            Log.i((String)TAG, (String)"Native crash handler initialized.");
        }
    }

    public static void reportNativeCrash(String string, String string2) {
        string2 = NativeCrashHandler.fixNativeBacktrace(string2);
        Log.v((String)TAG, (String)("Crash occurred in native code: " + string + "\n" + string2));
        Class<?> clazz = delegate.getClass();
        Class[] classArray = new Class[2];
        classArray[0] = String.class;
        try {
            classArray[1] = String.class;
            clazz.getDeclaredMethod("didCrash", classArray).invoke(delegate, string, string2);
        }
        catch (Throwable throwable) {
            Log.v((String)TAG, (String)"Throwable during reportNativeCrash", (Throwable)throwable);
        }
    }

    public static int initializeCrashHandler(Object object, String string) {
        Log.v((String)TAG, (String)("Native crash handler was initialized with delegate: " + object));
        delegate = object;
        return NativeCrashHandler.initialize(string);
    }

    public static void deinitializeCrashHandler() {
        Log.v((String)TAG, (String)"Native crash handler was deinitialized.");
        delegate = null;
        NativeCrashHandler.deinitialize();
    }

    public static String fixNativeBacktrace(String charSequence) {
        Stack<String> stack;
        StringBuilder stringBuilder;
        String string = charSequence;
        charSequence = stringBuilder;
        stringBuilder = new StringBuilder();
        Stack<String> stack2 = stack;
        stack = new Stack<String>();
        int n = 0;
        for (String string2 : string.split("\n")) {
            if (string2.endsWith("backtrace:")) {
                CharSequence charSequence2 = charSequence;
                n = 1;
                ((StringBuilder)charSequence2).append(string2);
                ((StringBuilder)charSequence2).append('\n');
                continue;
            }
            if (n == 0) {
                CharSequence charSequence3 = charSequence;
                ((StringBuilder)charSequence3).append(string2);
                ((StringBuilder)charSequence3).append('\n');
                continue;
            }
            stack2.push(string2);
        }
        n = stack2.size();
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence4 = charSequence;
            ((StringBuilder)charSequence4).append((String)stack2.pop());
            ((StringBuilder)charSequence4).append('\n');
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static native void crashIntentionally();

    public static native int initialize(String var0);

    public static native boolean deinitialize();
}

