/*
 * Decompiled with CFR 0.152.
 */
package com.testdroid.api;

import com.testdroid.api.APIClient;
import com.testdroid.api.APIEntity;
import com.testdroid.api.APIException;
import java.io.InputStream;

public class APIResource<T extends APIEntity> {
    protected final APIClient client;
    protected final Class<T> type;
    protected final String resourceURI;
    private T entity;

    public APIResource(APIClient client, String resourceURI, Class<T> type) {
        this.client = client;
        this.resourceURI = resourceURI;
        this.type = type;
    }

    public T getEntity() throws APIException {
        this.refresh();
        return this.entity;
    }

    public InputStream getStream() throws APIException {
        return this.client.get(this.resourceURI);
    }

    public T update() throws APIException {
        this.entity = this.client.post(this.resourceURI, null, this.type);
        return this.entity;
    }

    public void delete() throws APIException {
        this.client.delete(this.resourceURI);
        this.entity = null;
    }

    public void refresh() throws APIException {
        this.entity = this.client.get(this.resourceURI, this.type);
    }
}

