/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logstash;

import com.tersesystems.echopraxia.api.Attributes;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import java.util.List;
import net.logstash.logback.marker.ObjectAppendingMarker;
import org.jetbrains.annotations.NotNull;

public class MappedFieldMarker
extends ObjectAppendingMarker
implements Field {
    private final Field textField;
    private final Field structuredField;

    public MappedFieldMarker(Field originalField, Field structuredField) {
        super(structuredField.name(), (Object)structuredField.value());
        this.textField = originalField;
        this.structuredField = structuredField;
    }

    public Field getTextField() {
        return this.textField;
    }

    public Field getStructuredField() {
        return this.structuredField;
    }

    @NotNull
    public String name() {
        return this.structuredField.name();
    }

    @NotNull
    public Value<?> value() {
        return this.structuredField.value();
    }

    @NotNull
    public List<Field> fields() {
        return this.structuredField.fields();
    }

    @NotNull
    public Attributes attributes() {
        return this.textField.attributes();
    }

    public String toStringSelf() {
        return EchopraxiaService.getInstance().getToStringFormatter().formatField(this.textField);
    }
}

