/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logstash;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.logback.DirectFieldMarker;
import com.tersesystems.echopraxia.logback.TransformingAppender;
import com.tersesystems.echopraxia.logstash.FieldMarker;
import java.util.ArrayList;
import java.util.List;
import net.logstash.logback.marker.Markers;
import org.slf4j.Marker;

public class LogstashFieldAppender
extends TransformingAppender<ILoggingEvent> {
    protected ILoggingEvent decorateEvent(ILoggingEvent eventObject) {
        Object[] argumentArray;
        Marker marker = eventObject.getMarker();
        if (marker != null) {
            ArrayList<FieldMarker> markers = new ArrayList<FieldMarker>();
            if (marker instanceof DirectFieldMarker) {
                List fields = ((DirectFieldMarker)marker).getFields();
                for (Field field : fields) {
                    markers.add(new FieldMarker(field));
                }
            }
            for (Marker m : marker) {
                if (!(m instanceof DirectFieldMarker)) continue;
                List fields = ((DirectFieldMarker)m).getFields();
                for (Field field : fields) {
                    markers.add(new FieldMarker(field));
                }
            }
            marker.add((Marker)Markers.aggregate(markers));
        }
        if ((argumentArray = eventObject.getArgumentArray()) != null) {
            for (int i = 0; i < argumentArray.length; ++i) {
                Throwable throwable;
                Field field;
                Object arg = argumentArray[i];
                if (!(arg instanceof Field)) continue;
                field = (Field)arg;
                argumentArray[i] = new FieldMarker(field);
                if (eventObject.getThrowableProxy() != null || (throwable = this.extractThrowable(field)) == null) continue;
                ((LoggingEvent)eventObject).setThrowableProxy(new ThrowableProxy(throwable));
            }
        }
        return eventObject;
    }

    protected Throwable extractThrowable(Field field) {
        Value value = field.value();
        if (value.type() == Value.Type.EXCEPTION) {
            Value.ExceptionValue throwable = (Value.ExceptionValue)value;
            return throwable.raw();
        }
        return null;
    }
}

