/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logstash;

import ch.qos.logback.classic.LoggerContext;
import com.tersesystems.echopraxia.logstash.LogstashCoreLogger;
import com.tersesystems.echopraxia.spi.AbstractEchopraxiaService;
import com.tersesystems.echopraxia.spi.CoreLogger;
import java.util.ServiceConfigurationError;
import org.jetbrains.annotations.NotNull;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public class LogstashEchopraxiaService
extends AbstractEchopraxiaService {
    private static final int retryCount = Integer.parseInt(System.getProperty("echopraxia.logback.retries", "10"));
    protected volatile LoggerContext loggerContext;

    protected void initialize() {
        if (this.loggerContext == null && this.loggerContext == null) {
            int retries = retryCount;
            ILoggerFactory factory = null;
            while (retries > 0) {
                try {
                    factory = LoggerFactory.getILoggerFactory();
                    if (factory instanceof LoggerContext) {
                        this.loggerContext = (LoggerContext)factory;
                        break;
                    }
                    System.err.println("LogstashLoggerProvider: Logback still initializing, sleeping for 100 ms...");
                    --retries;
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.loggerContext == null) {
                System.err.println("LogstashLoggerProvider: No Logback implementation can be found after 10 retries.  Giving up.");
                throw new ServiceConfigurationError("Invalid ILoggerFactory implementation " + factory);
            }
        }
    }

    public LogstashEchopraxiaService() {
        this.initialize();
    }

    @NotNull
    public CoreLogger getCoreLogger(@NotNull String fqcn, @NotNull Class<?> clazz) {
        return this.getCoreLogger(fqcn, clazz.getName());
    }

    @NotNull
    public CoreLogger getCoreLogger(@NotNull String fqcn, @NotNull String name) {
        return new LogstashCoreLogger(fqcn, this.loggerContext.getLogger(name));
    }
}

