/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logstash;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import com.tersesystems.echopraxia.api.Condition;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldBuilderResult;
import com.tersesystems.echopraxia.api.LoggerHandle;
import com.tersesystems.echopraxia.api.LoggingContext;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.logback.CallerMarker;
import com.tersesystems.echopraxia.logback.LogbackLoggerContext;
import com.tersesystems.echopraxia.logback.LogbackLoggingContext;
import com.tersesystems.echopraxia.logstash.FieldMarker;
import com.tersesystems.echopraxia.spi.CoreLogger;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import com.tersesystems.echopraxia.spi.Utilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.logstash.logback.marker.Markers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class LogstashCoreLogger
implements CoreLogger {
    public static final String ECHOPRAXIA_ASYNC_CALLER_PROPERTY = "echopraxia.async.caller";
    private final Logger logger;
    private final LogstashMarkerContext context;
    private final Condition condition;
    private final Executor executor;
    private final String fqcn;
    private final Supplier<Runnable> threadContextFunction;

    public LogstashCoreLogger(@NotNull String fqcn, @NotNull Logger logger) {
        this.fqcn = fqcn;
        this.logger = logger;
        this.context = LogstashMarkerContext.empty();
        this.condition = Condition.always();
        this.executor = ForkJoinPool.commonPool();
        this.threadContextFunction = this.mdcContext();
    }

    public LogstashCoreLogger(@NotNull String fqcn, @NotNull Logger logger, @NotNull LogstashMarkerContext context, @NotNull Condition condition, @NotNull Executor executor, @NotNull Supplier<Runnable> threadContextSupplier) {
        this.fqcn = fqcn;
        this.logger = logger;
        this.context = context;
        this.condition = condition;
        this.executor = executor;
        this.threadContextFunction = threadContextSupplier;
    }

    private Supplier<Runnable> mdcContext() {
        return () -> {
            Map copyOfContextMap = MDC.getCopyOfContextMap();
            return () -> {
                if (copyOfContextMap != null) {
                    MDC.setContextMap((Map)copyOfContextMap);
                }
            };
        };
    }

    public Logger logger() {
        return this.logger;
    }

    @NotNull
    public String getName() {
        return this.logger.getName();
    }

    @NotNull
    public Condition condition() {
        return this.condition;
    }

    @NotNull
    public String fqcn() {
        return this.fqcn;
    }

    public CoreLogger withMarkers(Marker ... markers) {
        LogstashMarkerContext contextWithMarkers = this.context.withMarkers(() -> Arrays.asList(markers));
        return new LogstashCoreLogger(this.fqcn, this.logger, contextWithMarkers, this.condition, this.executor, this.threadContextFunction);
    }

    @NotNull
    public <FB> CoreLogger withFields(@NotNull Function<FB, FieldBuilderResult> f, @NotNull FB builder) {
        LogstashMarkerContext contextWithFields = this.context.withFields(() -> this.convertToFields((FieldBuilderResult)f.apply(builder)));
        return new LogstashCoreLogger(this.fqcn, this.logger, contextWithFields, this.condition, this.executor, this.threadContextFunction);
    }

    @NotNull
    public CoreLogger withThreadContext(@NotNull Function<Supplier<Map<String, String>>, Supplier<List<Field>>> mapTransform) {
        LogstashMarkerContext newContext = this.context.withFields(mapTransform.apply(MDC::getCopyOfContextMap));
        return new LogstashCoreLogger(this.fqcn, this.logger, newContext, this.condition, this.executor, this.threadContextFunction);
    }

    @NotNull
    public CoreLogger withThreadLocal(Supplier<Runnable> newThreadContextFunction) {
        Supplier<Runnable> joinedThreadContextFunction = () -> {
            Runnable r1 = (Runnable)newThreadContextFunction.get();
            Runnable r2 = this.threadContextFunction.get();
            return () -> {
                try {
                    r1.run();
                    r2.run();
                }
                catch (Exception e) {
                    LogstashCoreLogger.handleException(e);
                }
            };
        };
        return new LogstashCoreLogger(this.fqcn, this.logger, this.context, this.condition, this.executor, joinedThreadContextFunction);
    }

    @NotNull
    public CoreLogger withCondition(@NotNull Condition condition) {
        if (condition == Condition.always()) {
            return this;
        }
        if (condition == Condition.never()) {
            if (this.condition == Condition.never()) {
                return this;
            }
            return new LogstashCoreLogger(this.fqcn, this.logger, this.context, condition, this.executor, this.threadContextFunction);
        }
        return new LogstashCoreLogger(this.fqcn, this.logger, this.context, this.condition.and(condition), this.executor, this.threadContextFunction);
    }

    @NotNull
    public CoreLogger withExecutor(@NotNull Executor executor) {
        return new LogstashCoreLogger(this.fqcn, this.logger, this.context, this.condition, executor, this.threadContextFunction);
    }

    @NotNull
    public CoreLogger withFQCN(@NotNull String fqcn) {
        return new LogstashCoreLogger(fqcn, this.logger, this.context, this.condition, this.executor, this.threadContextFunction);
    }

    public boolean isEnabled(@NotNull com.tersesystems.echopraxia.api.Level level) {
        try {
            if (this.condition == Condition.always()) {
                return this.logger.isEnabledFor(this.context.resolveMarkers(), this.convertLogbackLevel(level));
            }
            if (this.condition == Condition.never()) {
                return false;
            }
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context);
                return this.condition.test(level, (LoggingContext)snapshotContext);
            }
            return false;
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
            return false;
        }
    }

    public boolean isEnabled(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Condition condition) {
        try {
            Condition bothConditions = this.condition.and(condition);
            if (bothConditions == Condition.always()) {
                return this.logger.isEnabledFor(this.context.resolveMarkers(), this.convertLogbackLevel(level));
            }
            if (bothConditions == Condition.never()) {
                return false;
            }
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context);
                return bothConditions.test(level, (LoggingContext)snapshotContext);
            }
            return false;
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
            return false;
        }
    }

    public boolean isEnabled(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields) {
        try {
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields));
                return this.condition.test(level, (LoggingContext)snapshotContext);
            }
            return false;
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
            return false;
        }
    }

    public boolean isEnabled(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Condition condition, @NotNull Supplier<List<Field>> extraFields) {
        try {
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields));
                return this.condition.and(condition).test(level, (LoggingContext)snapshotContext);
            }
            return false;
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
            return false;
        }
    }

    public void log(@NotNull com.tersesystems.echopraxia.api.Level level, String message) {
        try {
            LogbackLoggingContext snapshotContext;
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level)) && this.condition.test(level, (LoggingContext)(snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context)))) {
                this.logger.log(this.resolveLoggerFields(m, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, null, null);
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @Nullable String message) {
        try {
            LogbackLoggingContext snapshotContext;
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level)) && this.condition.test(level, (LoggingContext)(snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields))))) {
                this.logger.log(this.resolveLoggerFields(m, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, null, null);
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void log(@NotNull com.tersesystems.echopraxia.api.Level level, String message, @NotNull Function<FB, FieldBuilderResult> f, @NotNull FB builder) {
        try {
            LogbackLoggingContext ctx;
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level)) && this.condition.test(level, (LoggingContext)(ctx = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context, () -> this.convertToFields((FieldBuilderResult)f.apply(builder)))))) {
                Object[] arguments = this.convertArguments(ctx.getArgumentFields());
                this.logger.log(this.resolveLoggerFields(m, (LoggingContext)ctx), this.fqcn, this.convertLevel(level), message, arguments, null);
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @Nullable String message, @NotNull Function<FB, FieldBuilderResult> f, @NotNull FB builder) {
        try {
            LogbackLoggingContext ctx;
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level)) && this.condition.test(level, (LoggingContext)(ctx = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields), () -> this.convertToFields((FieldBuilderResult)f.apply(builder)))))) {
                Object[] arguments = this.convertArguments(ctx.getArgumentFields());
                this.logger.log(this.resolveLoggerFields(m, (LoggingContext)ctx), this.fqcn, this.convertLevel(level), message, arguments, null);
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Condition condition, String message) {
        try {
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context);
                if (this.condition.and(condition).test(level, (LoggingContext)snapshotContext)) {
                    this.logger.log(this.resolveLoggerFields(m, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, null, null);
                }
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @NotNull Condition condition, @Nullable String message) {
        try {
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields));
                if (this.condition.and(condition).test(level, (LoggingContext)snapshotContext)) {
                    this.logger.log(this.resolveLoggerFields(m, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, null, null);
                }
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Condition condition, @Nullable String message, @NotNull Function<FB, FieldBuilderResult> f, @NotNull FB builder) {
        try {
            Marker m = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(m, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context, () -> this.convertToFields((FieldBuilderResult)f.apply(builder)));
                if (this.condition.and(condition).test(level, (LoggingContext)snapshotContext)) {
                    Object[] arguments = this.convertArguments(snapshotContext.getArgumentFields());
                    this.logger.log(this.resolveLoggerFields(m, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, arguments, null);
                }
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void log(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @NotNull Condition condition, @Nullable String message, @NotNull Function<FB, FieldBuilderResult> f, @NotNull FB builder) {
        try {
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                LogbackLoggingContext snapshotContext = new LogbackLoggingContext((CoreLogger)this, (LogbackLoggerContext)this.context.withFields(extraFields), () -> this.convertToFields((FieldBuilderResult)f.apply(builder)));
                if (this.condition.and(condition).test(level, (LoggingContext)snapshotContext)) {
                    Object[] arguments = this.convertArguments(snapshotContext.getArgumentFields());
                    this.logger.log(this.resolveLoggerFields(marker, (LoggingContext)snapshotContext), this.fqcn, this.convertLevel(level), message, arguments, null);
                }
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    @NotNull
    public <FB> LoggerHandle<FB> logHandle(final @NotNull com.tersesystems.echopraxia.api.Level level, final @NotNull FB builder) {
        return new LoggerHandle<FB>(){
            private final Marker m;
            private final int logbackLevel;
            {
                this.m = LogstashCoreLogger.this.context.resolveMarkers();
                this.logbackLevel = LogstashCoreLogger.this.convertLevel(level);
            }

            public void log(@Nullable String message) {
                try {
                    LogbackLoggingContext ctx = new LogbackLoggingContext((CoreLogger)LogstashCoreLogger.this, (LogbackLoggerContext)LogstashCoreLogger.this.context);
                    LogstashCoreLogger.this.logger.log(LogstashCoreLogger.this.resolveLoggerFields(this.m, (LoggingContext)ctx), LogstashCoreLogger.this.fqcn, this.logbackLevel, message, null, null);
                }
                catch (Exception e) {
                    LogstashCoreLogger.handleException(e);
                }
            }

            public void log(@Nullable String message, @NotNull Function<FB, FieldBuilderResult> f) {
                try {
                    LogbackLoggingContext ctx = new LogbackLoggingContext((CoreLogger)LogstashCoreLogger.this, (LogbackLoggerContext)LogstashCoreLogger.this.context, () -> LogstashCoreLogger.this.convertToFields((FieldBuilderResult)f.apply(builder)));
                    Object[] arguments = LogstashCoreLogger.this.convertArguments(ctx.getArgumentFields());
                    LogstashCoreLogger.this.logger.log(LogstashCoreLogger.this.resolveLoggerFields(this.m, (LoggingContext)ctx), LogstashCoreLogger.this.fqcn, this.logbackLevel, message, arguments, null);
                }
                catch (Exception e) {
                    LogstashCoreLogger.handleException(e);
                }
            }
        };
    }

    public <FB> void asyncLog(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Consumer<LoggerHandle<FB>> consumer, @NotNull FB builder) {
        try {
            Marker marker = this.context.resolveMarkers();
            if (this.logger.isEnabledFor(marker, this.convertLogbackLevel(level))) {
                CallerMarker callerMarker = this.isAsyncCallerEnabled() ? new CallerMarker(this.fqcn, new Throwable()) : null;
                Runnable threadLocalRunnable = this.threadContextFunction.get();
                this.runAsyncLog(() -> this.lambda$asyncLog$10(threadLocalRunnable, (Marker)callerMarker, consumer, level, builder));
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void asyncLog(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Condition c, @NotNull Consumer<LoggerHandle<FB>> consumer, @NotNull FB builder) {
        try {
            if (this.logger.isEnabledFor(this.context.resolveMarkers(), this.convertLogbackLevel(level))) {
                CallerMarker result = this.isAsyncCallerEnabled() ? new CallerMarker(this.fqcn, new Throwable()) : null;
                Runnable threadLocalRunnable = this.threadContextFunction.get();
                this.runAsyncLog(() -> {
                    threadLocalRunnable.run();
                    LogstashCoreLogger callerLogger = this.newLogger(this.newContext((Marker)result));
                    LoggerHandle<Object> loggerHandle = this.newHandle(level, c, builder, callerLogger);
                    consumer.accept(loggerHandle);
                });
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void asyncLog(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @NotNull Consumer<LoggerHandle<FB>> consumer, @NotNull FB builder) {
        try {
            if (this.logger.isEnabledFor(this.context.resolveMarkers(), this.convertLogbackLevel(level))) {
                CallerMarker callerMarker = this.isAsyncCallerEnabled() ? new CallerMarker(this.fqcn, new Throwable()) : null;
                Runnable threadLocalRunnable = this.threadContextFunction.get();
                this.runAsyncLog(() -> this.lambda$asyncLog$12(threadLocalRunnable, extraFields, (Marker)callerMarker, level, builder, consumer));
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public <FB> void asyncLog(@NotNull com.tersesystems.echopraxia.api.Level level, @NotNull Supplier<List<Field>> extraFields, @NotNull Condition c, @NotNull Consumer<LoggerHandle<FB>> consumer, @NotNull FB builder) {
        try {
            if (this.logger.isEnabledFor(this.context.resolveMarkers(), this.convertLogbackLevel(level))) {
                CallerMarker callerMarker = this.isAsyncCallerEnabled() ? new CallerMarker(this.fqcn, new Throwable()) : null;
                Runnable threadLocalRunnable = this.threadContextFunction.get();
                this.runAsyncLog(() -> this.lambda$asyncLog$13(threadLocalRunnable, extraFields, (Marker)callerMarker, level, c, builder, consumer));
            }
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    protected boolean isAsyncCallerEnabled() {
        LoggerContext loggerContext = this.logger.getLoggerContext();
        if (loggerContext != null) {
            return Boolean.parseBoolean(loggerContext.getProperty(ECHOPRAXIA_ASYNC_CALLER_PROPERTY));
        }
        return false;
    }

    protected Object[] convertArguments(List<Field> args) {
        Throwable throwable = null;
        ArrayList<Object> arguments = new ArrayList<Object>(args.size() + 1);
        for (Field field : args) {
            Value value = field.value();
            if (value.type() == Value.Type.EXCEPTION) {
                throwable = ((Value.ExceptionValue)value).raw();
            }
            arguments.add((Object)new FieldMarker(field));
        }
        if (throwable != null) {
            arguments.add(throwable);
        }
        return arguments.toArray();
    }

    protected void runAsyncLog(Runnable runnable) {
        CompletableFuture.runAsync(runnable, this.executor).exceptionally(e -> {
            Throwable cause = e.getCause();
            this.logger.error("Uncaught exception when running asyncLog", cause);
            return null;
        });
    }

    protected Level convertLogbackLevel(com.tersesystems.echopraxia.api.Level level) {
        switch (level) {
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new IllegalStateException("No level found!");
    }

    protected int convertLevel(com.tersesystems.echopraxia.api.Level level) {
        switch (level) {
            case ERROR: {
                return 40;
            }
            case WARN: {
                return 30;
            }
            case INFO: {
                return 20;
            }
            case DEBUG: {
                return 10;
            }
            case TRACE: {
                return 0;
            }
        }
        throw new IllegalStateException("No level found!");
    }

    @NotNull
    protected LogstashMarkerContext newContext(@NotNull Supplier<List<Field>> fieldsSupplier, Marker callerMarker) {
        Supplier loggerFields = Utilities.joinFields(fieldsSupplier, this.context::getLoggerFields);
        Supplier<List<Marker>> markers = callerMarker == null ? this.context::getMarkers : LogstashMarkerContext.joinMarkers(() -> Collections.singletonList(callerMarker), this.context::getMarkers);
        return new LogstashMarkerContext(loggerFields, markers);
    }

    protected LogstashMarkerContext newContext(Marker callerMarker) {
        if (callerMarker == null) {
            return this.context;
        }
        Supplier<List<Marker>> markers = LogstashMarkerContext.joinMarkers(() -> Collections.singletonList(callerMarker), this.context::getMarkers);
        return new LogstashMarkerContext(this.context::getLoggerFields, markers);
    }

    protected LogstashCoreLogger newLogger(LogstashMarkerContext newContext) {
        return new LogstashCoreLogger(this.fqcn, this.logger, newContext, this.condition, this.executor, this.threadContextFunction);
    }

    @NotNull
    protected <FB> LoggerHandle<FB> newHandle(final @NotNull com.tersesystems.echopraxia.api.Level level, final @NotNull FB builder, final LogstashCoreLogger callerLogger) {
        return new LoggerHandle<FB>(){

            public void log(@Nullable String message) {
                callerLogger.log(level, message);
            }

            public void log(@Nullable String message, @NotNull Function<FB, FieldBuilderResult> f) {
                callerLogger.log(level, message, f, builder);
            }
        };
    }

    protected <FB> LoggerHandle<FB> newHandle(final @NotNull com.tersesystems.echopraxia.api.Level level, final @NotNull Condition c, final @NotNull FB builder, final LogstashCoreLogger callerLogger) {
        return new LoggerHandle<FB>(){

            public void log(@Nullable String message) {
                callerLogger.log(level, c, message);
            }

            public void log(@Nullable String message, @NotNull Function<FB, FieldBuilderResult> f) {
                callerLogger.log(level, c, message, f, builder);
            }
        };
    }

    private Marker resolveLoggerFields(Marker ctxMarker, LoggingContext ctx) {
        List fields = ctx.getLoggerFields();
        if (fields.isEmpty()) {
            return ctxMarker;
        }
        ArrayList<FieldMarker> markerList = new ArrayList<FieldMarker>(fields.size() + 1);
        for (Field field : fields) {
            markerList.add(new FieldMarker(field));
        }
        if (ctxMarker != null) {
            markerList.add((FieldMarker)ctxMarker);
        }
        return Markers.aggregate(markerList);
    }

    private List<Field> convertToFields(FieldBuilderResult result) {
        if (result == null) {
            return Collections.emptyList();
        }
        return result.fields();
    }

    public String toString() {
        return "LogstashCoreLogger[" + this.logger.getName() + "]";
    }

    private static void handleException(Exception e) {
        EchopraxiaService.getInstance().getExceptionHandler().handleException((Throwable)e);
    }

    private /* synthetic */ void lambda$asyncLog$13(Runnable threadLocalRunnable, Supplier extraFields, Marker callerMarker, com.tersesystems.echopraxia.api.Level level, Condition c, Object builder, Consumer consumer) {
        threadLocalRunnable.run();
        LogstashCoreLogger callerLogger = this.newLogger(this.newContext(extraFields, callerMarker));
        LoggerHandle<Object> loggerHandle = this.newHandle(level, c, builder, callerLogger);
        consumer.accept(loggerHandle);
    }

    private /* synthetic */ void lambda$asyncLog$12(Runnable threadLocalRunnable, Supplier extraFields, Marker callerMarker, com.tersesystems.echopraxia.api.Level level, Object builder, Consumer consumer) {
        threadLocalRunnable.run();
        LogstashCoreLogger callerLogger = this.newLogger(this.newContext(extraFields, callerMarker));
        LoggerHandle<Object> loggerHandle = this.newHandle(level, builder, callerLogger);
        consumer.accept(loggerHandle);
    }

    private /* synthetic */ void lambda$asyncLog$10(Runnable threadLocalRunnable, Marker callerMarker, Consumer consumer, com.tersesystems.echopraxia.api.Level level, Object builder) {
        try {
            threadLocalRunnable.run();
            LogstashCoreLogger callerLogger = this.newLogger(this.newContext(callerMarker));
            consumer.accept(this.newHandle(level, builder, callerLogger));
        }
        catch (Exception e) {
            LogstashCoreLogger.handleException(e);
        }
    }

    public static class LogstashMarkerContext
    implements LogbackLoggerContext {
        private static final LogstashMarkerContext EMPTY = new LogstashMarkerContext(Collections::emptyList, Collections::emptyList);
        private final Supplier<List<Field>> fieldsSupplier;
        private final Supplier<List<Marker>> markersSupplier;
        private final Supplier<Marker> markersResult;

        public LogstashMarkerContext(Supplier<List<Field>> f, Supplier<List<Marker>> m) {
            this.fieldsSupplier = f;
            this.markersSupplier = m;
            this.markersResult = Utilities.memoize(() -> {
                List<Marker> markers = this.getMarkers();
                if (markers.isEmpty()) {
                    return null;
                }
                if (markers.size() == 1) {
                    return markers.get(0);
                }
                return Markers.aggregate(markers);
            });
        }

        public static LogstashMarkerContext empty() {
            return EMPTY;
        }

        @NotNull
        public List<Field> getLoggerFields() {
            return this.fieldsSupplier.get();
        }

        @NotNull
        public List<Marker> getMarkers() {
            return this.markersSupplier.get();
        }

        public LogstashMarkerContext withFields(Supplier<List<Field>> o) {
            Supplier joinedFields = Utilities.joinFields(this::getLoggerFields, o);
            return new LogstashMarkerContext(joinedFields, this::getMarkers);
        }

        public LogstashMarkerContext withMarkers(Supplier<List<Marker>> o) {
            Supplier<List<Marker>> joinedMarkers = LogstashMarkerContext.joinMarkers(this::getMarkers, o);
            return new LogstashMarkerContext(this::getLoggerFields, joinedMarkers);
        }

        static Supplier<List<Marker>> joinMarkers(Supplier<List<Marker>> markersSupplier, Supplier<List<Marker>> thisMarkersSupplier) {
            return () -> {
                List markers = (List)markersSupplier.get();
                List thisMarkers = (List)thisMarkersSupplier.get();
                if (markers.isEmpty()) {
                    return thisMarkers;
                }
                if (thisMarkers.isEmpty()) {
                    return markers;
                }
                return Stream.concat(thisMarkers.stream(), markers.stream()).collect(Collectors.toList());
            };
        }

        @Nullable
        Marker resolveMarkers() {
            return this.markersResult.get();
        }
    }
}

