/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import com.tersesystems.echopraxia.api.Condition;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldBuilderResult;
import com.tersesystems.echopraxia.api.Level;
import com.tersesystems.echopraxia.api.LoggingContext;
import com.tersesystems.echopraxia.logback.ConditionMarker;
import com.tersesystems.echopraxia.logback.DirectFieldMarker;
import com.tersesystems.echopraxia.logback.LogbackLoggerContext;
import com.tersesystems.echopraxia.logback.LogbackLoggingContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;

public class ConditionTurboFilter
extends TurboFilter {
    public FilterReply decide(Marker marker, Logger logger, ch.qos.logback.classic.Level level, String s, Object[] arguments, Throwable throwable) {
        if (marker == null) {
            return FilterReply.NEUTRAL;
        }
        Level echoLevel = this.level(level);
        LoggingContext loggingContext = null;
        if (marker instanceof ConditionMarker) {
            loggingContext = this.loggingContext(marker, arguments);
            Condition condition = ((ConditionMarker)marker).getCondition();
            if (!condition.test(echoLevel, loggingContext)) {
                return FilterReply.DENY;
            }
        }
        for (Marker m : marker) {
            if (!(m instanceof ConditionMarker)) continue;
            Condition condition = ((ConditionMarker)m).getCondition();
            if (loggingContext == null) {
                loggingContext = this.loggingContext(marker, arguments);
            }
            if (condition.test(echoLevel, loggingContext)) continue;
            return FilterReply.DENY;
        }
        return FilterReply.NEUTRAL;
    }

    private Level level(ch.qos.logback.classic.Level level) {
        return Level.valueOf((String)level.levelStr);
    }

    private LoggingContext loggingContext(Marker marker, Object[] arguments) {
        FilterMarkerContext markerContext = new FilterMarkerContext(marker);
        return new LogbackLoggingContext(null, markerContext, () -> this.getFields(arguments));
    }

    @NotNull
    private List<Field> getFields(Object[] argumentArray) {
        List<Field> fields;
        if (argumentArray == null || argumentArray.length == 0) {
            fields = Collections.emptyList();
        } else {
            fields = new ArrayList<Field>();
            for (Object arg : argumentArray) {
                if (arg instanceof Field) {
                    fields.add((Field)arg);
                }
                if (!(arg instanceof FieldBuilderResult)) continue;
                FieldBuilderResult result = (FieldBuilderResult)arg;
                fields.addAll(result.fields());
            }
        }
        return fields;
    }

    public static class FilterMarkerContext
    implements LogbackLoggerContext {
        private final Marker marker;
        private final List<Field> fields;

        public FilterMarkerContext(Marker marker) {
            this.marker = marker;
            this.fields = this.extractFields(marker);
        }

        private List<Field> extractFields(Marker marker) {
            if (marker == null) {
                return Collections.emptyList();
            }
            if (marker instanceof DirectFieldMarker) {
                return ((DirectFieldMarker)marker).getFields();
            }
            if (marker.hasReferences()) {
                ArrayList<Field> list = new ArrayList<Field>();
                for (Marker m : marker) {
                    if (!(m instanceof DirectFieldMarker)) continue;
                    list.addAll(((DirectFieldMarker)m).getFields());
                }
                return list;
            }
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Field> getLoggerFields() {
            return this.fields;
        }

        @Override
        public List<Marker> getMarkers() {
            return Collections.singletonList(this.marker);
        }
    }
}

