/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import com.tersesystems.echopraxia.logback.CallerMarker;
import com.tersesystems.echopraxia.logback.TransformingAppender;
import java.util.List;
import org.slf4j.Marker;

public class CallerDataAppender
extends TransformingAppender<ILoggingEvent> {
    @Override
    protected ILoggingEvent decorateEvent(ILoggingEvent eventObject) {
        return this.setCallerData(eventObject);
    }

    protected ILoggingEvent setCallerData(ILoggingEvent event) {
        LoggingEvent internalEvent = (LoggingEvent)event;
        Marker marker = event.getMarker();
        if (marker == null) {
            return event;
        }
        if (marker instanceof CallerMarker) {
            StackTraceElement[] stackTraceElements = this.extractFromMarker((CallerMarker)marker);
            internalEvent.setCallerData(stackTraceElements);
            return internalEvent;
        }
        for (Marker next : marker) {
            if (!(next instanceof CallerMarker)) continue;
            StackTraceElement[] stackTraceElements = this.extractFromMarker((CallerMarker)next);
            internalEvent.setCallerData(stackTraceElements);
            return event;
        }
        return event;
    }

    private StackTraceElement[] extractFromMarker(CallerMarker callerMarker) {
        String fqcn = callerMarker.getFqcn();
        Throwable callSite = callerMarker.getCallSite();
        return this.extractCallerData(fqcn, callSite);
    }

    protected StackTraceElement[] extractCallerData(String fqcn, Throwable callsite) {
        LoggerContext loggerContext = (LoggerContext)this.getContext();
        return CallerData.extract((Throwable)callsite, (String)fqcn, (int)loggerContext.getMaxCallerDataDepth(), (List)loggerContext.getFrameworkPackages());
    }
}

