/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import org.slf4j.Marker;

public abstract class BaseMarker
implements Marker {
    private final String name;
    private List<Marker> referenceList;
    private static final String OPEN = "[ ";
    private static final String CLOSE = " ]";
    private static final String SEP = ", ";

    public BaseMarker(String name) {
        Objects.requireNonNull(name, "A marker name cannot be null");
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void add(Marker reference) {
        Objects.requireNonNull(reference, "A null value cannot be added to a Marker as reference.");
        if (!this.contains(reference) && !reference.contains((Marker)this)) {
            if (this.referenceList == null) {
                this.referenceList = new Vector<Marker>();
            }
            this.referenceList.add(reference);
        }
    }

    public synchronized boolean hasReferences() {
        return this.referenceList != null && this.referenceList.size() > 0;
    }

    @Deprecated
    public boolean hasChildren() {
        return this.hasReferences();
    }

    public synchronized Iterator<Marker> iterator() {
        return this.hasReferences() ? this.referenceList.iterator() : Collections.emptyIterator();
    }

    public synchronized boolean remove(Marker referenceToRemove) {
        if (this.hasReferences()) {
            return this.referenceList.remove(referenceToRemove);
        }
        return false;
    }

    public boolean contains(Marker other) {
        Objects.requireNonNull(other, "other cannot be null");
        if (this.equals(other)) {
            return true;
        }
        if (this.hasReferences()) {
            return this.referenceList.stream().anyMatch(ref -> ref.contains(other));
        }
        return false;
    }

    public boolean contains(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        if (this.name.equals(name)) {
            return true;
        }
        if (this.hasReferences()) {
            return this.referenceList.stream().anyMatch(ref -> ref.contains(name));
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marker)) {
            return false;
        }
        Marker other = (Marker)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        if (!this.hasReferences()) {
            return this.getName();
        }
        Iterator<Marker> it = this.iterator();
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append(' ').append(OPEN);
        while (it.hasNext()) {
            Marker reference = it.next();
            sb.append(reference.getName());
            if (!it.hasNext()) continue;
            sb.append(SEP);
        }
        sb.append(CLOSE);
        return sb.toString();
    }
}

