/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.tersesystems.echopraxia.logback.AbstractEventLoggingContext;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

abstract class AbstractPathConverter
extends ClassicConverter {
    protected String jsonPath;

    AbstractPathConverter() {
    }

    public void start() {
        String optStr = this.getFirstOption();
        if (optStr != null) {
            this.jsonPath = optStr;
            super.start();
        }
        if (this.jsonPath == null) {
            throw new IllegalStateException("JSON path is not specified");
        }
    }

    public String convert(ILoggingEvent event) {
        AbstractEventLoggingContext ctx = this.getLoggingContext(event);
        try {
            if (ctx.getFields().isEmpty()) {
                return "";
            }
            Optional<Object> optObject = ctx.find(this.jsonPath);
            return optObject.map(o -> o.toString()).orElse("");
        }
        catch (Exception e) {
            this.addError("Cannot convert path " + this.jsonPath, e);
            return "";
        }
    }

    @NotNull
    protected abstract AbstractEventLoggingContext getLoggingContext(ILoggingEvent var1);
}

