/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;

public class ValueSerializer
extends StdSerializer<Value> {
    static final ValueSerializer INSTANCE = new ValueSerializer();

    public ValueSerializer() {
        super(Value.class);
    }

    public void serialize(Value value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value == null || value.raw() == null) {
            gen.writeNull();
            return;
        }
        switch (value.type()) {
            case ARRAY: {
                List arrayValues = ((Value.ArrayValue)value).raw();
                gen.writeStartArray();
                for (Value arrayValue : arrayValues) {
                    gen.writeObject((Object)arrayValue);
                }
                gen.writeEndArray();
                break;
            }
            case OBJECT: {
                List objFields = ((Value.ObjectValue)value).raw();
                gen.writeStartObject();
                for (Field objField : objFields) {
                    gen.writeObject((Object)objField);
                }
                gen.writeEndObject();
                break;
            }
            case STRING: {
                gen.writeString(value.raw().toString());
                break;
            }
            case NUMBER: {
                Number n = ((Value.NumberValue)value).raw();
                if (n instanceof Byte) {
                    gen.writeNumber((short)n.byteValue());
                    break;
                }
                if (n instanceof Short) {
                    gen.writeNumber(n.shortValue());
                    break;
                }
                if (n instanceof Integer) {
                    gen.writeNumber(n.intValue());
                    break;
                }
                if (n instanceof Long) {
                    gen.writeNumber(n.longValue());
                    break;
                }
                if (n instanceof Double) {
                    gen.writeNumber(n.doubleValue());
                    break;
                }
                if (n instanceof BigInteger) {
                    gen.writeNumber((BigInteger)n);
                    break;
                }
                if (!(n instanceof BigDecimal)) break;
                gen.writeNumber((BigDecimal)n);
                break;
            }
            case BOOLEAN: {
                boolean b = ((Value.BooleanValue)value).raw();
                gen.writeBoolean(b);
                break;
            }
            case EXCEPTION: {
                Throwable throwable = ((Value.ExceptionValue)value).raw();
                gen.writeString(throwable.toString());
                break;
            }
            case NULL: {
                gen.writeNull();
            }
        }
    }
}

