/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.jackson;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class ValueDeserializer
extends StdDeserializer<Value<?>> {
    static final ValueDeserializer INSTANCE = new ValueDeserializer();

    public ValueDeserializer() {
        super(Value.class);
    }

    public Value<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
        JsonNode jsonNode = (JsonNode)p.readValueAs(JsonNode.class);
        return this.processNode(jsonNode);
    }

    private Value<?> processNode(JsonNode jsonNode) {
        switch (jsonNode.getNodeType()) {
            case ARRAY: {
                return this.processArrayValue(jsonNode);
            }
            case BINARY: {
                return Value.string((String)jsonNode.textValue());
            }
            case BOOLEAN: {
                return Value.bool((Boolean)jsonNode.booleanValue());
            }
            case MISSING: {
                return Value.nullValue();
            }
            case NULL: {
                return Value.nullValue();
            }
            case NUMBER: {
                switch (jsonNode.numberType()) {
                    case INT: {
                        return Value.number((Integer)jsonNode.asInt());
                    }
                    case LONG: {
                        return Value.number((Long)jsonNode.asLong());
                    }
                    case BIG_INTEGER: {
                        return Value.number((BigInteger)((BigInteger)jsonNode.numberValue()));
                    }
                    case FLOAT: {
                        return Value.number((Float)Float.valueOf(jsonNode.floatValue()));
                    }
                    case DOUBLE: {
                        return Value.number((Double)jsonNode.asDouble());
                    }
                    case BIG_DECIMAL: {
                        return Value.number((BigDecimal)((BigDecimal)jsonNode.numberValue()));
                    }
                }
            }
            case OBJECT: {
                return this.processObjectValue(jsonNode);
            }
            case POJO: {
                throw new IllegalStateException("No POJO accepted for " + jsonNode);
            }
            case STRING: {
                return Value.string((String)jsonNode.textValue());
            }
        }
        throw new IllegalStateException("Unknown node type " + jsonNode.getNodeType());
    }

    private Value<?> processObjectValue(JsonNode jsonNode) {
        ObjectNode node = (ObjectNode)jsonNode;
        ArrayList<Field> fields = new ArrayList<Field>();
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Value<?> value = this.processNode((JsonNode)entry.getValue());
            Field field = Field.keyValue((String)((String)entry.getKey()), value);
            fields.add(field);
        }
        return Value.object(fields);
    }

    private Value<?> processArrayValue(JsonNode jsonNode) {
        ArrayList values = new ArrayList();
        for (JsonNode arrayItem : jsonNode) {
            Value<?> value = this.processNode(arrayItem);
            values.add(value);
        }
        return Value.array(values);
    }
}

