/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldVisitor;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.PresentationHintAttributes;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;

public class FieldSerializer
extends StdSerializer<Field> {
    static final FieldSerializer INSTANCE = new FieldSerializer();

    public FieldSerializer() {
        this(Field.class);
    }

    protected FieldSerializer(Class<Field> t) {
        super(t);
    }

    public void serialize(Field input, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        Field field;
        Optional fieldVisitorOpt = input.attributes().getOptional(PresentationHintAttributes.STRUCTURED_FORMAT);
        if (fieldVisitorOpt.isPresent()) {
            FieldVisitor fieldVisitor = (FieldVisitor)fieldVisitorOpt.get();
            field = fieldVisitor.visit(input);
        } else {
            field = input;
        }
        String name = field.name();
        Value value = field.value();
        if (value.raw() == null) {
            jgen.writeNullField(name);
            return;
        }
        switch (value.type()) {
            case ARRAY: {
                List arrayValues = ((Value.ArrayValue)value).raw();
                jgen.writeArrayFieldStart(name);
                for (Value av : arrayValues) {
                    if (av != null) {
                        jgen.writeObject((Object)av);
                        continue;
                    }
                    jgen.writeNull();
                }
                jgen.writeEndArray();
                break;
            }
            case OBJECT: {
                List objFields = ((Value.ObjectValue)value).raw();
                jgen.writeObjectFieldStart(name);
                for (Field objField : objFields) {
                    jgen.writeObject((Object)objField);
                }
                jgen.writeEndObject();
                break;
            }
            case STRING: {
                jgen.writeStringField(name, value.raw().toString());
                break;
            }
            case NUMBER: {
                Number n = ((Value.NumberValue)value).raw();
                if (n instanceof Byte) {
                    jgen.writeNumberField(name, (short)n.byteValue());
                    break;
                }
                if (n instanceof Short) {
                    jgen.writeNumberField(name, n.shortValue());
                    break;
                }
                if (n instanceof Integer) {
                    jgen.writeNumberField(name, n.intValue());
                    break;
                }
                if (n instanceof Long) {
                    jgen.writeNumberField(name, n.longValue());
                    break;
                }
                if (n instanceof Double) {
                    jgen.writeNumberField(name, n.doubleValue());
                    break;
                }
                if (n instanceof BigInteger) {
                    jgen.writeNumberField(name, (BigInteger)n);
                    break;
                }
                if (!(n instanceof BigDecimal)) break;
                jgen.writeNumberField(name, (BigDecimal)n);
                break;
            }
            case BOOLEAN: {
                boolean b = ((Value.BooleanValue)value).raw();
                jgen.writeBooleanField(name, b);
                break;
            }
            case EXCEPTION: {
                break;
            }
            case NULL: {
                jgen.writeNullField(name);
            }
        }
    }
}

