/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.LoggingContext;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.FieldConstants;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class EchopraxiaJsonProvider
implements JsonProvider {
    private static final List<String> THROWABLE_KEYS = Arrays.asList(FieldConstants.MESSAGE, FieldConstants.CAUSE, FieldConstants.STACK_TRACE, FieldConstants.CLASS_NAME);
    private static final List<String> STACK_TRACE_ELEMENT_KEYS = Arrays.asList(FieldConstants.METHOD_NAME, FieldConstants.LINE_NUMBER, FieldConstants.FILE_NAME, FieldConstants.CLASS_NAME);

    public Object parse(String json) throws InvalidJsonException {
        throw new InvalidJsonException("Not implemented");
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        throw new InvalidJsonException("Not implemented");
    }

    public String toJson(Object obj) {
        throw new InvalidJsonException("Not implemented");
    }

    public boolean isMap(Object obj) {
        return obj instanceof LoggingContext || obj instanceof Value.ObjectValue || obj instanceof Value.ExceptionValue || obj instanceof Throwable || obj instanceof StackTraceElement || obj instanceof Map;
    }

    public Object unwrap(Object obj) {
        if (obj instanceof Value) {
            return ((Value)obj).raw();
        }
        return obj;
    }

    public boolean isArray(Object obj) {
        return obj instanceof Value.ArrayValue || obj instanceof List || obj.getClass().isArray();
    }

    public int length(Object obj) {
        if (this.isArray(obj)) {
            return this.arraySize(obj);
        }
        if (this.isMap(obj)) {
            return this.getPropertyKeys(obj).size();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        throw new JsonPathException("length operation cannot be applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    public Iterable<?> toIterable(Object obj) {
        if (obj instanceof List) {
            return (Iterable)obj;
        }
        if (obj instanceof Value.ArrayValue) {
            return ((Value.ArrayValue)obj).raw();
        }
        throw new JsonPathException("Cannot iterate over " + obj != null ? obj.getClass().getName() : "null");
    }

    public Collection<String> getPropertyKeys(Object obj) {
        if (this.isArray(obj)) {
            throw new UnsupportedOperationException();
        }
        if (obj instanceof Map) {
            return ((Map)obj).keySet();
        }
        if (obj instanceof Value.ObjectValue) {
            return ((Value.ObjectValue)obj).raw().stream().map(Field::name).collect(Collectors.toList());
        }
        if (obj instanceof LoggingContext) {
            return ((LoggingContext)obj).getFields().stream().map(Field::name).collect(Collectors.toList());
        }
        if (obj instanceof Throwable) {
            return THROWABLE_KEYS;
        }
        if (obj instanceof StackTraceElement) {
            return STACK_TRACE_ELEMENT_KEYS;
        }
        throw new JsonPathException("Cannot get property values for " + obj != null ? obj.getClass().getName() : "null");
    }

    private int arraySize(Object obj) {
        if (obj instanceof Value.ArrayValue) {
            return ((Value.ArrayValue)obj).raw().size();
        }
        if (obj instanceof List) {
            return ((List)obj).size();
        }
        if (obj != null && obj.getClass().isArray()) {
            return ((Object[])obj).length;
        }
        throw new JsonPathException("length operation cannot be applied to " + (obj != null ? obj.getClass().getName() : "null"));
    }

    public void setProperty(Object obj, Object key, Object value) {
        if (!(obj instanceof Map)) {
            throw new JsonPathException("setProperty operation cannot be used with " + obj != null ? obj.getClass().getName() : "null");
        }
        ((Map)obj).put(key.toString(), value);
    }

    public void removeProperty(Object obj, Object key) {
        if (obj instanceof Map) {
            ((Map)obj).remove(key.toString());
        } else if (obj instanceof List) {
            List list = (List)obj;
            int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
            list.remove(index);
        } else {
            throw new JsonPathException("removeProperty operation cannot be used with " + obj != null ? obj.getClass().getName() : "null");
        }
    }

    public Object getArrayIndex(Object obj, int idx) {
        if (obj instanceof Value.ArrayValue) {
            Object raw = ((Value.ArrayValue)obj).raw();
            return raw.get(idx);
        }
        if (obj instanceof List) {
            return ((List)obj).get(idx);
        }
        if (obj.getClass().isArray()) {
            return ((Object[])obj)[idx];
        }
        throw new IllegalArgumentException("Object is not valid: " + obj);
    }

    @Deprecated
    public Object getArrayIndex(Object obj, int idx, boolean unwrap) {
        return this.getArrayIndex(obj, idx);
    }

    public void setArrayIndex(Object array, int idx, Object newValue) {
        if (!(array instanceof List)) {
            throw new UnsupportedOperationException();
        }
        List l = (List)array;
        if (idx == l.size()) {
            l.add(newValue);
        } else {
            l.set(idx, newValue);
        }
    }

    public Object getMapValue(Object obj, String key) {
        if (obj instanceof LoggingContext) {
            return this.findValue(key, ((LoggingContext)obj).getFields());
        }
        if (obj instanceof Value.ObjectValue) {
            return this.findValue(key, (List<Field>)((Value.ObjectValue)obj).raw());
        }
        if (obj instanceof Value.ExceptionValue) {
            return this.findExceptionValue(key, ((Value.ExceptionValue)obj).raw());
        }
        if (obj instanceof Throwable) {
            return this.findExceptionValue(key, (Throwable)obj);
        }
        if (obj instanceof StackTraceElement) {
            return this.findStackTraceValue(key, (StackTraceElement)obj);
        }
        return JsonProvider.UNDEFINED;
    }

    private Object findStackTraceValue(String key, StackTraceElement obj) {
        if (key.equals(FieldConstants.FILE_NAME)) {
            return obj.getFileName();
        }
        if (key.equals(FieldConstants.LINE_NUMBER)) {
            return obj.getLineNumber();
        }
        if (key.equals(FieldConstants.CLASS_NAME)) {
            return obj.getClassName();
        }
        if (key.equals(FieldConstants.METHOD_NAME)) {
            return obj.getMethodName();
        }
        return JsonProvider.UNDEFINED;
    }

    private Object findExceptionValue(String key, Throwable throwable) {
        if (key.equals(FieldConstants.MESSAGE)) {
            return throwable.getMessage();
        }
        if (key.equals(FieldConstants.CAUSE)) {
            return throwable.getCause();
        }
        if (key.equals(FieldConstants.STACK_TRACE)) {
            return throwable.getStackTrace();
        }
        if (key.equals(FieldConstants.CLASS_NAME)) {
            return throwable.getClass().getName();
        }
        return JsonProvider.UNDEFINED;
    }

    @NotNull
    private Object findValue(String key, List<Field> fields) {
        Optional<Value> first = fields.stream().filter(f -> f.name().equals(key)).map(Field::value).findFirst();
        return first.isPresent() ? first.get() : JsonProvider.UNDEFINED;
    }

    public List<Object> createArray() {
        return new LinkedList<Object>();
    }

    public Object createMap() {
        return new LinkedHashMap();
    }
}

