/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.api.Attributes;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.ToStringFormatter;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.PresentationHintAttributes;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class DefaultToStringFormatter
implements ToStringFormatter {
    @Override
    @NotNull
    public String formatField(@NotNull Field field) {
        StringBuilder builder = new StringBuilder();
        if (this.isElided(field)) {
            return "";
        }
        if (!this.isValueOnly(field)) {
            this.formatName(builder, field.name(), field.attributes());
        }
        this.formatValue(builder, field.value(), field.attributes());
        return builder.toString();
    }

    @Override
    @NotNull
    public String formatValue(@NotNull Value<?> value) {
        if (value.type() == Value.Type.OBJECT) {
            StringBuilder b = new StringBuilder();
            this.formatObject(b, value.asObject());
            return b.toString();
        }
        return String.valueOf(value.raw());
    }

    private void formatValue(@NotNull StringBuilder b, @NotNull Value<?> v, @NotNull Attributes attributes) {
        if (v.type() == Value.Type.OBJECT) {
            this.formatObject(b, v.asObject());
        } else if (attributes.containsKey(PresentationHintAttributes.AS_CARDINAL) && v.type() == Value.Type.ARRAY) {
            b.append("|").append(v.asArray().raw().size()).append("|");
        } else if (attributes.containsKey(PresentationHintAttributes.AS_CARDINAL) && v.type() == Value.Type.STRING) {
            b.append("|").append(v.asString().raw().length()).append("|");
        } else if (attributes.containsKey(PresentationHintAttributes.ABBREVIATE_AFTER)) {
            String abbreviated = this.abbreviateValue(v, attributes.get(PresentationHintAttributes.ABBREVIATE_AFTER));
            b.append(abbreviated);
        } else {
            b.append(v.raw());
        }
    }

    private String abbreviateValue(Value<?> v, Integer maxWidth) {
        switch (v.type()) {
            case STRING: {
                String s = v.asString().raw();
                if (s.length() > maxWidth) {
                    int correctedMaxWidth = Character.isLowSurrogate(s.charAt(maxWidth)) && maxWidth > 0 ? maxWidth - 1 : maxWidth;
                    return s.substring(0, correctedMaxWidth) + "...";
                }
                return s;
            }
            case ARRAY: {
                Object elements = v.asArray().raw();
                if (elements.size() > maxWidth) {
                    String limited = elements.stream().limit(maxWidth.intValue()).map(Value::toString).collect(Collectors.joining(", "));
                    return "[" + limited + "...]";
                }
                return elements.toString();
            }
        }
        return v.raw().toString();
    }

    private void formatObject(@NotNull StringBuilder b, @NotNull Value.ObjectValue v) {
        Object fieldList = v.raw();
        b.append("{");
        boolean displayComma = false;
        for (int i = 0; i < fieldList.size(); ++i) {
            Field field = (Field)fieldList.get(i);
            if (this.isElided(field)) continue;
            if (displayComma) {
                b.append(", ");
            }
            if (!this.isValueOnly(field)) {
                this.formatName(b, field.name(), field.attributes());
            }
            this.formatValue(b, field.value(), field.attributes());
            displayComma = i < fieldList.size();
        }
        b.append("}");
    }

    private void formatName(@NotNull StringBuilder builder, @NotNull String name, @NotNull Attributes attributes) {
        if (attributes.containsKey(PresentationHintAttributes.DISPLAY_NAME)) {
            String displayName = attributes.get(PresentationHintAttributes.DISPLAY_NAME);
            builder.append("\"").append(displayName).append("\"");
        } else {
            builder.append(name);
        }
        builder.append("=");
    }

    private boolean isValueOnly(Field field) {
        return field.attributes().getOptional(PresentationHintAttributes.VALUE_ONLY).orElse(false);
    }

    private boolean isElided(Field field) {
        return field.attributes().getOptional(PresentationHintAttributes.ELIDE).orElse(false);
    }
}

