/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.EchopraxiaJsonProvider;
import com.tersesystems.echopraxia.spi.EchopraxiaMappingProvider;
import com.tersesystems.echopraxia.spi.FieldConstants;
import com.tersesystems.echopraxia.spi.FindPathMethods;
import com.tersesystems.echopraxia.spi.Utilities;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractJsonPathFinder
implements FindPathMethods {
    private static final String EXCEPTION_PATH = "$." + FieldConstants.EXCEPTION;
    private static final JsonProvider jsonProvider = new EchopraxiaJsonProvider();
    private static final MappingProvider javaMappingProvider = new EchopraxiaMappingProvider();
    private static final Configuration configuration = Configuration.builder().jsonProvider(jsonProvider).options(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).mappingProvider(javaMappingProvider).build();
    private final Supplier<DocumentContext> supplier = Utilities.memoize(() -> JsonPath.parse((Object)this, (Configuration)configuration));

    @NotNull
    protected <T> Optional<T> optionalFind(@NotNull @Language(value="JSONPath") String jsonPath, @NotNull Class<T> desiredClass) {
        DocumentContext documentContext = this.getDocumentContext();
        Object o = documentContext.read(jsonPath, new Predicate[0]);
        if (desiredClass.isInstance(o)) {
            return Optional.of(desiredClass.cast(o));
        }
        Object convertedObject = javaMappingProvider.map(o, desiredClass, configuration);
        if (desiredClass.isInstance(convertedObject)) {
            return Optional.of(convertedObject);
        }
        return Optional.empty();
    }

    @Override
    @NotNull
    public Optional<String> findString(@NotNull @Language(value="JSONPath") String jsonPath) {
        return this.optionalFind(jsonPath, String.class);
    }

    @Override
    @NotNull
    public Optional<Boolean> findBoolean(@NotNull @Language(value="JSONPath") String jsonPath) {
        return this.optionalFind(jsonPath, Boolean.class);
    }

    @Override
    @NotNull
    public Optional<Number> findNumber(@NotNull @Language(value="JSONPath") String jsonPath) {
        return this.optionalFind(jsonPath, Number.class);
    }

    @Override
    public boolean findNull(@NotNull String jsonPath) {
        Object o = this.getDocumentContext().read(jsonPath, new Predicate[0]);
        return o == null || o instanceof Value.NullValue;
    }

    @Override
    @NotNull
    public Optional<Throwable> findThrowable(@NotNull @Language(value="JSONPath") String jsonPath) {
        return this.optionalFind(jsonPath, Value.ExceptionValue.class).map(Value.ExceptionValue::raw);
    }

    @Override
    @NotNull
    public Optional<Throwable> findThrowable() {
        return this.findThrowable(EXCEPTION_PATH);
    }

    @Override
    @NotNull
    public Optional<Map<String, ?>> findObject(@NotNull @Language(value="JSONPath") String jsonPath) {
        return this.optionalFind(jsonPath, Map.class).map(f -> f);
    }

    @Override
    @NotNull
    public List<?> findList(@NotNull @Language(value="JSONPath") String jsonPath) {
        Object o = this.getDocumentContext().read(jsonPath, new Predicate[0]);
        if (o instanceof Value.ArrayValue || o instanceof List || o instanceof Object[]) {
            return (List)javaMappingProvider.map(o, List.class, configuration);
        }
        if (o != null) {
            Value value = (Value)o;
            return Collections.singletonList(value.raw());
        }
        return Collections.emptyList();
    }

    private DocumentContext getDocumentContext() {
        return this.supplier.get();
    }
}

