/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.ToStringFormatter;
import com.tersesystems.echopraxia.spi.DefaultToStringFormatter;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import com.tersesystems.echopraxia.spi.ExceptionHandler;
import com.tersesystems.echopraxia.spi.FieldCreator;
import com.tersesystems.echopraxia.spi.Filters;
import java.util.Collections;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractEchopraxiaService
implements EchopraxiaService {
    private static final ClassLoader[] classLoaders = new ClassLoader[]{ClassLoader.getSystemClassLoader()};
    private final ConcurrentHashMap<Class<?>, FieldCreator<?>> fieldCreatorMap;
    protected Filters filters;
    protected ToStringFormatter toStringFormatter;
    protected ExceptionHandler exceptionHandler = Throwable::printStackTrace;

    public AbstractEchopraxiaService() {
        this.toStringFormatter = new DefaultToStringFormatter();
        this.filters = this.initFilters();
        this.fieldCreatorMap = new ConcurrentHashMap();
    }

    private Filters initFilters() {
        try {
            return new Filters(classLoaders);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException(e);
            return new Filters(Collections.emptyList());
        }
    }

    @Override
    @NotNull
    public Filters getFilters() {
        return this.filters;
    }

    @Override
    @NotNull
    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    @NotNull
    public ToStringFormatter getToStringFormatter() {
        return this.toStringFormatter;
    }

    @Override
    @NotNull
    public <F extends Field> FieldCreator<F> getFieldCreator(@NotNull Class<F> fieldClass) {
        return this.fieldCreatorMap.computeIfAbsent(fieldClass, AbstractEchopraxiaService::loadFieldCreator);
    }

    private static <T extends Field> FieldCreator<T> loadFieldCreator(Class<?> t) {
        for (FieldCreator s : ServiceLoader.load(FieldCreator.class)) {
            if (!s.canServe(t)) continue;
            return s;
        }
        throw new UnsupportedOperationException("No field creator found for class " + t);
    }
}

