/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Attributes;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldVisitor;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.DefaultField;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import com.tersesystems.echopraxia.spi.FieldCreator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SimpleFieldVisitor
implements FieldVisitor {
    protected final FieldCreator<?> fieldCreator;
    protected Attributes attributes;
    protected String name;

    public SimpleFieldVisitor() {
        this(DefaultField.class);
    }

    public <F extends Field> SimpleFieldVisitor(Class<F> fieldClass) {
        this(EchopraxiaService.getInstance().getFieldCreator(fieldClass));
    }

    public SimpleFieldVisitor(FieldCreator<?> fieldCreator) {
        this.fieldCreator = fieldCreator;
    }

    @Override
    public Field visit(@NotNull Field f) {
        this.visitAttributes(f.attributes());
        this.visitName(f.name());
        return this.visitValue(f.value());
    }

    public Field visitValue(Value<?> value) {
        switch (value.type()) {
            case OBJECT: {
                FieldVisitor.ObjectVisitor objectVisitor = this.visitObject();
                Iterator iterator = value.asObject().raw().iterator();
                while (iterator.hasNext()) {
                    Field child = (Field)iterator.next();
                    FieldVisitor subVisitor = objectVisitor.visitChild();
                    objectVisitor.visit(subVisitor.visit(child));
                }
                return objectVisitor.done();
            }
            case ARRAY: {
                FieldVisitor.ArrayVisitor arrayVisitor = this.visitArray();
                Iterator iterator = value.asArray().raw().iterator();
                while (iterator.hasNext()) {
                    Value el = (Value)iterator.next();
                    arrayVisitor.visitElement(el);
                }
                return arrayVisitor.done();
            }
            case STRING: {
                return this.visitString(value.asString());
            }
            case NUMBER: {
                return this.visitNumber(value.asNumber());
            }
            case BOOLEAN: {
                return this.visitBoolean(value.asBoolean());
            }
            case EXCEPTION: {
                return this.visitException(value.asException());
            }
            case NULL: {
                return this.visitNull();
            }
        }
        throw new IllegalStateException("Unknown value type!");
    }

    @Override
    public void visitAttributes(@NotNull Attributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public void visitName(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public Field visitString(@NotNull Value<String> stringValue) {
        return this.fieldCreator.create(this.name, stringValue, this.attributes);
    }

    @Override
    @NotNull
    public Field visitException(@NotNull Value<Throwable> exceptionValue) {
        return this.fieldCreator.create(this.name, exceptionValue, this.attributes);
    }

    @Override
    @NotNull
    public Field visitBoolean(@NotNull Value<Boolean> booleanValue) {
        return this.fieldCreator.create(this.name, booleanValue, this.attributes);
    }

    @Override
    @NotNull
    public Field visitNumber(@NotNull Value<? extends Number> numberValue) {
        return this.fieldCreator.create(this.name, numberValue, this.attributes);
    }

    @Override
    @NotNull
    public Field visitNull() {
        return this.fieldCreator.create(this.name, Value.nullValue(), this.attributes);
    }

    @Override
    @NotNull
    public FieldVisitor.ArrayVisitor visitArray() {
        return new SimpleArrayVisitor();
    }

    @Override
    @NotNull
    public FieldVisitor.ObjectVisitor visitObject() {
        return new SimpleObjectVisitor();
    }

    public class SimpleArrayVisitor
    implements FieldVisitor.ArrayVisitor {
        protected final List<Value<?>> elements = new ArrayList();

        @Override
        @NotNull
        public Field done() {
            return SimpleFieldVisitor.this.fieldCreator.create(SimpleFieldVisitor.this.name, Value.array(this.elements), SimpleFieldVisitor.this.attributes);
        }

        @Override
        public void visitElement(@NotNull Value<?> value) {
            switch (value.type()) {
                case ARRAY: {
                    this.visitArrayElement(value.asArray());
                    break;
                }
                case OBJECT: {
                    this.visitObjectElement(value.asObject());
                    break;
                }
                case STRING: {
                    this.visitStringElement(value.asString());
                    break;
                }
                case NUMBER: {
                    this.visitNumberElement(value.asNumber());
                    break;
                }
                case BOOLEAN: {
                    this.visitBooleanElement(value.asBoolean());
                    break;
                }
                case EXCEPTION: {
                    this.visitExceptionElement(value.asException());
                    break;
                }
                case NULL: {
                    this.visitNullElement();
                }
            }
        }

        @Override
        public void visitStringElement(Value.StringValue stringValue) {
            this.elements.add(stringValue);
        }

        @Override
        public void visitNumberElement(Value.NumberValue<?> numberValue) {
            this.elements.add(numberValue);
        }

        @Override
        public void visitBooleanElement(Value.BooleanValue booleanValue) {
            this.elements.add(booleanValue);
        }

        @Override
        public void visitArrayElement(Value.ArrayValue arrayValue) {
            this.elements.add(arrayValue);
        }

        @Override
        public void visitObjectElement(Value.ObjectValue objectValue) {
            this.elements.add(objectValue);
        }

        @Override
        public void visitExceptionElement(Value.ExceptionValue exceptionValue) {
            this.elements.add(exceptionValue);
        }

        @Override
        public void visitNullElement() {
            this.elements.add(Value.nullValue());
        }
    }

    public class SimpleObjectVisitor
    implements FieldVisitor.ObjectVisitor {
        protected final List<Field> fields = new ArrayList<Field>();

        @Override
        @NotNull
        public Field done() {
            return SimpleFieldVisitor.this.fieldCreator.create(SimpleFieldVisitor.this.name, Value.object(this.fields), SimpleFieldVisitor.this.attributes);
        }

        @Override
        public void visit(@NotNull Field childField) {
            this.fields.add(childField);
        }

        @Override
        @NotNull
        public FieldVisitor visitChild() {
            return SimpleFieldVisitor.this;
        }
    }
}

