/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldBuilderInstance;
import com.tersesystems.echopraxia.api.FieldBuilderResult;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.DefaultField;
import com.tersesystems.echopraxia.spi.FieldConstants;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface FieldBuilder {
    @NotNull
    public static FieldBuilder instance() {
        return FieldBuilderInstance.getInstance();
    }

    @NotNull
    default public FieldBuilderResult list(Field ... fields) {
        return FieldBuilderResult.list(fields);
    }

    @NotNull
    default public Field value(@NotNull String name, @NotNull Value<?> value) {
        return this.value(name, value, DefaultField.class);
    }

    @NotNull
    default public <F extends Field> F value(@NotNull String name, @NotNull Value<?> value, @NotNull Class<F> fieldClass) {
        return Field.value(name, value, fieldClass);
    }

    @NotNull
    default public Field keyValue(@NotNull String name, @NotNull Value<?> value) {
        return this.keyValue(name, value, DefaultField.class);
    }

    @NotNull
    default public <F extends Field> F keyValue(@NotNull String name, @NotNull Value<?> value, @NotNull Class<F> fieldClass) {
        return Field.keyValue(name, value, fieldClass);
    }

    @NotNull
    default public Field string(@NotNull String name, @NotNull String value) {
        return this.keyValue(name, Value.string(value));
    }

    @NotNull
    default public Field string(@NotNull String name, @NotNull Value.StringValue value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field number(@NotNull String name, @NotNull Byte value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull Short value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull Integer value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull Long value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull Float value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull Double value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull BigInteger value) {
        return this.keyValue(name, Value.number(value));
    }

    default public Field number(@NotNull String name, @NotNull BigDecimal value) {
        return this.keyValue(name, Value.number(value));
    }

    @NotNull
    default public <N extends Number> Field number(@NotNull String name, @NotNull Value.NumberValue<N> value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field bool(@NotNull String name, @NotNull Boolean value) {
        return this.keyValue(name, Value.bool(value));
    }

    @NotNull
    default public Field bool(@NotNull String name, @NotNull Value.BooleanValue value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field array(@NotNull String name, Value.ObjectValue ... values) {
        return this.keyValue(name, Value.array(values));
    }

    @NotNull
    default public Field array(@NotNull String name, String ... values) {
        return this.keyValue(name, Value.array(values));
    }

    @NotNull
    default public Field array(@NotNull String name, Byte ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, Short ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, Integer ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, Long ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, Double ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, Float ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, BigInteger ... values) {
        return this.keyValue(name, Value.array(values));
    }

    default public Field array(@NotNull String name, BigDecimal ... values) {
        return this.keyValue(name, Value.array(values));
    }

    @NotNull
    default public Field array(@NotNull String name, Boolean ... values) {
        return this.keyValue(name, Value.array(values));
    }

    @NotNull
    default public Field array(@NotNull String name, @NotNull Value.ArrayValue value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field object(@NotNull String name, Field ... values) {
        return this.keyValue(name, Value.object(values));
    }

    @NotNull
    default public Field object(@NotNull String name, @NotNull List<Field> values) {
        return this.keyValue(name, Value.object(values));
    }

    @NotNull
    default public Field object(@NotNull String name, @NotNull Value.ObjectValue value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field exception(@NotNull Throwable t) {
        return this.keyValue(FieldConstants.EXCEPTION, Value.exception(t));
    }

    @NotNull
    default public Field exception(@NotNull Value.ExceptionValue value) {
        return this.keyValue(FieldConstants.EXCEPTION, value);
    }

    @NotNull
    default public Field exception(@NotNull String name, @NotNull Throwable t) {
        return this.keyValue(name, Value.exception(t));
    }

    @NotNull
    default public Field exception(@NotNull String name, @NotNull Value.ExceptionValue value) {
        return this.keyValue(name, value);
    }

    @NotNull
    default public Field nullField(@NotNull String name) {
        return this.keyValue(name, Value.nullValue());
    }
}

