/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Attribute;
import com.tersesystems.echopraxia.api.AttributeKey;
import com.tersesystems.echopraxia.api.AttributesImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Attributes {
    @Nullable
    public <A> A get(@NotNull AttributeKey<A> var1);

    @NotNull
    public <A> Optional<A> getOptional(@NotNull AttributeKey<A> var1);

    public boolean containsKey(@NotNull AttributeKey<?> var1);

    @NotNull
    public <A> Attributes plus(@NotNull AttributeKey<A> var1, A var2);

    @NotNull
    public <A> Attributes plus(@NotNull Attribute<A> var1);

    @NotNull
    public Attributes plusAll(@NotNull Attributes var1);

    @NotNull
    public Attributes plusAll(@NotNull Attribute<?> var1, @NotNull Attribute<?> var2);

    @NotNull
    public Attributes plusAll(@NotNull Collection<Attribute<?>> var1);

    @NotNull
    public Attributes plusAll(@NotNull Map<AttributeKey<?>, ?> var1);

    @NotNull
    public Attributes minus(@NotNull AttributeKey<?> var1);

    @NotNull
    public Attributes minusAll(@NotNull Collection<AttributeKey<?>> var1);

    @NotNull
    public static Attributes empty() {
        return AttributesImpl.EMPTY;
    }

    @NotNull
    public static <A> Attributes create(@NotNull Attribute<A> attribute) {
        return Attributes.empty().plus(attribute.key(), attribute.value());
    }

    @NotNull
    public static Attributes create(@NotNull Attribute<?> a1, Attribute<?> a2) {
        return Attributes.empty().plusAll(a1, a2);
    }

    @NotNull
    public static Attributes create(@NotNull Collection<Attribute<?>> attrs) {
        return Attributes.empty().plusAll(attrs);
    }
}

