/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.keychain.KeyChain;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.security.KeyChainAccessor;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.SecretProvider;
import com.terracotta.management.security.SecretUtils;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecretKeyChainAccessor
implements KeyChainAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(SecretKeyChainAccessor.class);
    private final KeyChain keyChain;
    private final URL keychainUrl;

    public SecretKeyChainAccessor() throws KeychainInitializationException {
        String keychainUrl = System.getProperty("com.tc.security.keychain.url");
        String secretProviderClassName = System.getProperty("com.terracotta.express.SecretProvider");
        if (secretProviderClassName == null) {
            secretProviderClassName = System.getProperty("com.terracotta.SecretProvider");
        }
        String keychainImplClass = System.getProperty("com.tc.security.keychain.impl");
        SecretUtils.initProviderAndFetchSecret(secretProviderClassName);
        URL kcLoc = SecretUtils.validateKeychainUrl(keychainUrl);
        if (kcLoc != null) {
            try {
                this.keyChain = SecretUtils.loadKeychainImpl(keychainImplClass, kcLoc);
                this.keyChain.unlock(SecretProvider.getSecret());
            }
            catch (RuntimeException e) {
                throw new KeychainInitializationException(e);
            }
        } else {
            throw new KeychainInitializationException("Unable to locate a valid keychain for security context.");
        }
        this.keychainUrl = kcLoc;
    }

    @Override
    public byte[] retrieveSecret(KeyName alias) {
        byte[] secret = this.keyChain.getPassword(SecretProvider.getSecret(), alias);
        if (secret == null) {
            LOG.info("No secret found in keychain for URL: " + alias.toString());
        }
        return secret;
    }

    public String toString() {
        return "keychain @ " + this.keychainUrl;
    }
}

