/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.security.SecretUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PasswordStrengthVerifier {
    private static final Pattern PASSWORD_STRENGTH_PATTERN = Pattern.compile("^(?=.*[0-9])(?=.*[a-z])(?=.*[A-Z])(?=.*[\\Q!\\\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~\\E])(?=\\S+$).{8,}$");
    public static final char[] SPECIAL_CHARACTERS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~'};
    public static final String PASSWORD_POLICY_HINT = "At least 8 characters, no spaces. At least one upper letter. At least one number. And at least one special character";

    public static void verify(CharSequence password) {
        if (password == null) {
            throw new NullPointerException("Password is null");
        }
        Matcher matcher = PASSWORD_STRENGTH_PATTERN.matcher(password);
        if (!matcher.matches()) {
            throw new IllegalStateException("Password is not strong enough. Hint: At least 8 characters, no spaces. At least one upper letter. At least one number. And at least one special character");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void verify(byte[] password) {
        char[] tempChars = new char[]{};
        StringBuilder sb = new StringBuilder();
        try {
            byte[] secret = new byte[password.length];
            System.arraycopy(password, 0, secret, 0, password.length);
            tempChars = SecretUtils.toCharsAndWipe(secret);
            sb.append(tempChars);
            Arrays.fill(tempChars, '\u0000');
            PasswordStrengthVerifier.verify(sb);
        }
        finally {
            sb.delete(0, sb.length());
        }
    }
}

