/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.security.SecretProviderBackEnd;
import java.lang.reflect.Method;

public class DuckTypedSecretProviderBackend
implements SecretProviderBackEnd {
    private final Object secretProviderInstance;
    private final Method getSecretMethod;
    private final Method fetchSecretMethod;

    public DuckTypedSecretProviderBackend(Object secretProviderInstance) throws NoSuchMethodException {
        this.secretProviderInstance = secretProviderInstance;
        this.getSecretMethod = secretProviderInstance.getClass().getMethod("getSecret", new Class[0]);
        this.fetchSecretMethod = secretProviderInstance.getClass().getMethod("fetchSecret", new Class[0]);
    }

    @Override
    public byte[] getSecret() {
        try {
            return (byte[])this.getSecretMethod.invoke(this.secretProviderInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting secret", e);
        }
    }

    @Override
    public void fetchSecret() {
        try {
            this.fetchSecretMethod.invoke(this.secretProviderInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching secret", e);
        }
    }
}

