/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.keychain.FileStoreKeyChain;
import com.terracotta.management.keychain.KeyChain;
import com.terracotta.management.security.DuckTypedSecretProviderBackend;
import com.terracotta.management.security.KeychainInitializationException;
import com.terracotta.management.security.ObfuscatingSecretProviderBackend;
import com.terracotta.management.security.SecretProvider;
import com.terracotta.management.security.SecretProviderBackEnd;
import java.io.Console;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class SecretUtils {
    private static final String DFLT_KEYCHAIN_FILE_LOCATION = "file://" + System.getProperty("user.home").replace(File.separatorChar, '/') + "/.tc/mgmt/keychain";
    public static final String CUSTOM_IMPL_PROP = "com.tc.SecretProvider.impl";
    public static final String TERRACOTTA_KEYCHAIN_LOCATION_PROP = "com.tc.security.keychain.url";
    public static final String TERRACOTTA_KEYCHAIN_IMPL_CLASS_PROP = "com.tc.security.keychain.impl";
    public static final String TERRACOTTA_CUSTOM_SECRET_PROVIDER_PROP = "com.terracotta.SecretProvider";
    public static final String TERRACOTTA_CUSTOM_EXPRESS_SECRET_PROVIDER_PROP = "com.terracotta.express.SecretProvider";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static SecretProviderBackEnd newDefaultSecretProviderBackEndImpl() {
        SecretProviderBackEnd secretProviderBackEnd;
        String implClass = System.getProperty(CUSTOM_IMPL_PROP);
        if (implClass != null) {
            try {
                Class<?> clazz = Class.forName(implClass);
                secretProviderBackEnd = (SecretProviderBackEnd)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't load class '" + implClass + "'", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't instantiate SecretProvider's backing implementation '" + implClass + "'", e);
            }
        } else {
            secretProviderBackEnd = new ObfuscatingSecretProviderBackend();
        }
        return secretProviderBackEnd;
    }

    public static void installProviderAndFetchSecret(SecretProviderBackEnd secretProviderBackend) throws KeychainInitializationException {
        SecretProvider.fetchSecret(secretProviderBackend);
    }

    public static void initProviderAndFetchSecret(String secretProviderClassName) throws KeychainInitializationException {
        SecretProviderBackEnd secretProviderBackend;
        if (!SecretProvider.isInstalled()) {
            if (secretProviderClassName != null) {
                try {
                    Class<?> clazz;
                    try {
                        clazz = Class.forName(secretProviderClassName, true, Thread.currentThread().getContextClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        clazz = Class.forName(secretProviderClassName, true, SecretUtils.class.getClassLoader());
                    }
                    Object secretProvider = clazz.newInstance();
                    secretProviderBackend = new DuckTypedSecretProviderBackend(secretProvider);
                }
                catch (Exception e) {
                    throw new KeychainInitializationException("Failed to initialize custom SecretProvider.", e);
                }
            }
            secretProviderBackend = SecretUtils.newDefaultSecretProviderBackEndImpl();
        } else {
            secretProviderBackend = null;
        }
        SecretProvider.fetchSecret(secretProviderBackend);
    }

    public static URL validateKeychainUrl(String keychainUrl) throws KeychainInitializationException {
        URL kLoc;
        if (keychainUrl == null) {
            keychainUrl = DFLT_KEYCHAIN_FILE_LOCATION;
        }
        try {
            kLoc = new URL(keychainUrl);
        }
        catch (MalformedURLException e) {
            throw new KeychainInitializationException("Failed to instantiate keychain URL.", e);
        }
        return kLoc;
    }

    public static KeyChain loadKeychainImpl(String keychainImplClassName, URL keychainUrl) throws KeychainInitializationException {
        Class keychainImplClass = FileStoreKeyChain.class;
        try {
            if (keychainImplClassName != null) {
                keychainImplClass = Class.forName(keychainImplClassName);
            }
            return (KeyChain)keychainImplClass.getConstructor(URL.class).newInstance(keychainUrl);
        }
        catch (Exception e) {
            throw new KeychainInitializationException("Failed to load keychain implementation class.", e);
        }
    }

    public static byte[] toBytesAndWipe(char[] secret) {
        if (secret == null) {
            return null;
        }
        ByteBuffer source = UTF8_CHARSET.encode(CharBuffer.wrap(secret));
        byte[] array = new byte[source.remaining()];
        System.arraycopy(source.array(), 0, array, 0, array.length);
        Arrays.fill(secret, '\u0000');
        return array;
    }

    public static char[] toCharsAndWipe(byte[] secret) {
        if (secret == null) {
            return null;
        }
        CharBuffer source = UTF8_CHARSET.decode(ByteBuffer.wrap(secret));
        char[] array = new char[source.remaining()];
        System.arraycopy(source.array(), 0, array, 0, array.length);
        Arrays.fill(secret, (byte)0);
        return array;
    }

    public static byte[] fetchSecretFromConsole(String prompt) throws IllegalStateException {
        char[] secretChars = SecretUtils.fetchPasswordFromConsole(prompt);
        return SecretUtils.toBytesAndWipe(secretChars);
    }

    public static char[] fetchPasswordFromConsole(String prompt) throws IllegalStateException {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("Couldn't access a Console instance to fetch the password from!");
        }
        return console.readPassword(prompt, new Object[0]);
    }
}

