/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.keychain;

import com.terracotta.management.keychain.KeyChain;
import com.terracotta.management.keychain.KeyName;
import com.terracotta.management.keychain.crypto.AesEnigmaMachine;
import com.terracotta.management.keychain.crypto.EnigmaMachine;
import com.terracotta.management.keychain.crypto.SecretMismatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FileStoreKeyChain
implements KeyChain {
    private final EnigmaMachine enigmaMachine;
    private final File file;
    private volatile long fileLastModified;
    private final Lock readLock;
    private final Lock writeLock;
    private volatile Map<KeyName, byte[]> store;
    private volatile byte[] masterKey;

    public static FileStoreKeyChain createNewKeyStore(EnigmaMachine enigmaMachine, File file) throws IOException {
        return FileStoreKeyChain.createNewKeyStore(enigmaMachine, file, null);
    }

    public static FileStoreKeyChain createNewKeyStore(EnigmaMachine enigmaMachine, File file, byte[] key) throws IOException {
        if (file.getParentFile() != null && !file.getParentFile().mkdirs() && !file.getParentFile().exists()) {
            throw new IOException("Couldn't create the parent directory/ies: " + file.getParentFile().getAbsolutePath());
        }
        if (!file.createNewFile()) {
            throw new IllegalStateException("File exists already!");
        }
        FileStoreKeyChain fileStoreKeyChain = new FileStoreKeyChain(enigmaMachine, file);
        if (key != null) {
            fileStoreKeyChain.masterKey = key;
            fileStoreKeyChain.writeStoreToFile();
            fileStoreKeyChain.lock();
        }
        return fileStoreKeyChain;
    }

    public FileStoreKeyChain(URL url) {
        this(new AesEnigmaMachine(), new File(url.getFile()));
    }

    public FileStoreKeyChain(EnigmaMachine enigmaMachine, File file) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.enigmaMachine = enigmaMachine;
        if (!(file.exists() && file.canRead() && file.isFile())) {
            throw new IllegalArgumentException(file + " doesn't point to a valid file");
        }
        this.file = file;
        this.fileLastModified = file.lastModified();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getPassword(byte[] key, KeyName entryName) {
        this.refreshIfFileChanged();
        this.readLock.lock();
        try {
            this.verifyUnlocked();
            byte[] crypted = this.store.get(entryName);
            byte[] byArray = crypted != null ? this.enigmaMachine.decrypt(key, crypted) : null;
            return byArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean storePassword(byte[] key, KeyName entryName, byte[] password) {
        this.refreshIfFileChanged();
        this.writeLock.lock();
        try {
            this.verifyUnlocked();
            byte[] previous = this.store.put(entryName, this.enigmaMachine.encrypt(key, password));
            this.writeStoreToFile();
            boolean bl = previous == null;
            return bl;
        }
        catch (IOException e) {
            this.resetInMemoryData();
            throw new RuntimeException("Couldn't write to file " + this.file, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean removePassword(KeyName entryName) {
        this.refreshIfFileChanged();
        this.writeLock.lock();
        try {
            this.verifyUnlocked();
            boolean removed = this.store.remove(entryName) != null;
            this.writeStoreToFile();
            boolean bl = removed;
            return bl;
        }
        catch (IOException e) {
            this.resetInMemoryData();
            throw new RuntimeException("Couldn't write to file " + this.file, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void resetInMemoryData() {
        byte[] masterKey = this.masterKey;
        this.lock();
        this.unlock(masterKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() {
        this.writeLock.lock();
        try {
            this.masterKey = null;
            this.store = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void unlock(byte[] key) {
        this.writeLock.lock();
        try {
            this.masterKey = key;
            if (this.file.length() > 0L) {
                this.store = this.readStoreFromFile();
                if (this.store == null) {
                    this.store = new HashMap<KeyName, byte[]>();
                }
            } else {
                this.store = new HashMap<KeyName, byte[]>();
            }
        }
        catch (SecretMismatchException smex) {
            throw smex;
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read from file " + this.file, e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<KeyName> keys() {
        this.refreshIfFileChanged();
        this.readLock.lock();
        try {
            this.verifyUnlocked();
            Set<KeyName> set = this.store.keySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public byte[] getPassword(KeyName entryName) {
        return this.getPassword(this.masterKey, entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KeyName, byte[]> readStoreFromFile() throws ClassNotFoundException, IOException {
        byte[] fileContent;
        RandomAccessFile raf = new RandomAccessFile(this.file, "rw");
        try {
            FileLock lock = raf.getChannel().lock();
            try {
                fileContent = new byte[(int)raf.length()];
                raf.readFully(fileContent);
            }
            finally {
                lock.release();
            }
        }
        finally {
            raf.close();
        }
        byte[] bytes = this.enigmaMachine.decrypt(this.masterKey, fileContent);
        return this.deserializeStore(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<KeyName, byte[]> deserializeStore(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
        try {
            Map map = (Map)ois.readObject();
            return map;
        }
        finally {
            ois.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStoreToFile() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.file);
        try {
            FileLock lock = fos.getChannel().lock();
            try {
                fos.write(this.enigmaMachine.encrypt(this.masterKey, this.serializeStore()));
            }
            finally {
                lock.release();
            }
        }
        finally {
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeStore() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(this.store);
        }
        finally {
            oos.close();
        }
        return baos.toByteArray();
    }

    private void verifyUnlocked() {
        if (this.store == null || this.masterKey == null) {
            throw new IllegalStateException("Store is still locked! You need to unlock it first...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshIfFileChanged() {
        if (!Boolean.getBoolean("tc.keychain.detectFileChanges")) {
            return;
        }
        if (this.store == null || this.masterKey == null) {
            return;
        }
        if (this.file.lastModified() != this.fileLastModified) {
            this.writeLock.lock();
            try {
                if (this.file.lastModified() != this.fileLastModified) {
                    this.resetInMemoryData();
                    this.fileLastModified = this.file.lastModified();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

