package com.terracotta.management.keychain.crypto;

/**
 * A symmetric encryption & decryption tool
 * @author Alex Snaps
 */
public interface EnigmaMachine {

  /**
   * Encrypts!
   * @param key the key to encrypt
   * @param decrypted the decrypted form
   * @return the encrypted form
   */
  byte[] encrypt(byte[] key, byte[] decrypted);

  /**
   * Decrypts!
   * @param key the key to decrypt
   * @param crypted the encrypted form
   * @return the decrypted form
   */
  byte[] decrypt(byte[] key, byte[] crypted);
}
