/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import java.io.Console;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class SecretUtils {
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");

    public static byte[] toBytesAndWipe(char[] secret) {
        if (secret == null) {
            return null;
        }
        ByteBuffer source = UTF8_CHARSET.encode(CharBuffer.wrap(secret));
        byte[] array = new byte[source.remaining()];
        System.arraycopy(source.array(), 0, array, 0, array.length);
        Arrays.fill(secret, '\u0000');
        return array;
    }

    public static char[] toCharsAndWipe(byte[] secret) {
        if (secret == null) {
            return null;
        }
        CharBuffer source = UTF8_CHARSET.decode(ByteBuffer.wrap(secret));
        char[] array = new char[source.remaining()];
        System.arraycopy(source.array(), 0, array, 0, array.length);
        Arrays.fill(secret, (byte)0);
        return array;
    }

    public static byte[] fetchSecretFromConsole(String prompt) throws IllegalStateException {
        char[] secretChars = SecretUtils.fetchPasswordFromConsole(prompt);
        return SecretUtils.toBytesAndWipe(secretChars);
    }

    public static char[] fetchPasswordFromConsole(String prompt) throws IllegalStateException {
        Console console = System.console();
        if (console == null) {
            throw new IllegalStateException("Couldn't access a Console instance to fetch the password from!");
        }
        return console.readPassword(prompt, new Object[0]);
    }
}

