/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */
package com.terracotta.management.security;

import java.lang.reflect.Method;

/**
 * An implementation of {@link SecretProviderBackEnd} that delegates its method calls
 * to another object of any class, assuming it contains the exact same two methods
 * as the ones declared in {@link SecretProviderBackEnd}:
 * {@link SecretProviderBackEnd#getSecret()} and {@link SecretProviderBackEnd#fetchSecret()}.
 *
 * @author Ludovic Orban
 */
public class DuckTypedSecretProviderBackend implements SecretProviderBackEnd {

  private final Object secretProviderInstance;

  public DuckTypedSecretProviderBackend(Object secretProviderInstance) {
    this.secretProviderInstance = secretProviderInstance;
  }

  @Override
  public byte[] getSecret() {
    try {
      Method getSecretMethod = this.secretProviderInstance.getClass().getMethod("getSecret");
      return (byte[])getSecretMethod.invoke(secretProviderInstance);
    } catch (Exception e) {
      throw new RuntimeException("Error getting secret", e);
    }
  }

  @Override
  public void fetchSecret() {
    try {
      Method fetchSecretMethod = this.secretProviderInstance.getClass().getMethod("fetchSecret");
      fetchSecretMethod.invoke(secretProviderInstance);
    } catch (Exception e) {
      throw new RuntimeException("Error fetching secret", e);
    }
  }
}
