/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security;

/**
 * An implementation of {link SecretProviderBackEnd} that has a hard-coded secret,
 * rendering the security-level of the results little-better than obfuscation.
 * 
 * @author jhouse
 */
public class ObfuscatingSecretProviderBackend implements SecretProviderBackEnd {

  // 32 once-random bytes
  private static final byte[] secret = { 0x07, 0x10, 0x68, 0x73, 0x5a, 0x01, 0x2c, 0x6e, 0x47, 0x0f, 0x54, 0x4c, 0x63, 0x61, 0x68, 0x00, 0x6d, 0x76, 0x40, 0x45, 0x7a, 0x7a, 0x30, 0x3d, 0x11, 0x1b, 0x20, 0x1b, 0x75, 0x12, 0x1d, 0x3e };

  @Override
  public byte[] getSecret() {
    return secret;
  }

  @Override
  public void fetchSecret() {
    // nothing to do!
  }
}

