package com.terracotta.management.keychain.crypto;

import java.security.MessageDigest;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

/**
 * @author Alex Snaps
 */
public class AesEnigmaMachine implements EnigmaMachine {

  private static final byte[] iv = new byte[] {
      0x5f, 0x5f, 0x74, 0x63,
      0x5f, 0x64, 0x73, 0x6f,
      0x52, 0x75, 0x6c, 0x65,
      0x7a, 0x28, 0x29, 0x56
  };

  private final int iterations;

  public AesEnigmaMachine() {
    this(500);
  }

  public AesEnigmaMachine(final int iterations) {
    this.iterations = iterations;
  }

  @Override
  public byte[] encrypt(final byte[] key, final byte[] decrypted) {

    try {
      Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
      cipher.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(getMD5(key), "AES"), new IvParameterSpec(iv));
      byte[] bytes = decrypted;
      for(int i = 0; i < iterations; i++) {
        bytes = cipher.doFinal(bytes);
      }
      return bytes;
    } catch (Exception e) {
      throw new RuntimeException("Couldn't encrypt things", e);
    }
  }

  @Override
  public byte[] decrypt(final byte[] key, final byte[] crypted) {
    Cipher cipher;
    try {
      cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
      cipher.init(Cipher.DECRYPT_MODE, new SecretKeySpec(getMD5(key), "AES"), new IvParameterSpec(iv));
    } catch (Exception e) {
      throw new RuntimeException("Couldn't decrypt things", e);
    }
    try {
      byte[] bytes = crypted;
      for(int i = 0; i < iterations; i++) {
        bytes = cipher.doFinal(bytes);
      }
      return bytes;
    } catch (IllegalBlockSizeException e) {
      throw new SecretMismatchException(e);
    } catch (BadPaddingException e) {
      throw new SecretMismatchException(e);
    }
  }

  private byte[] getMD5(byte[] input) {
    try {
      MessageDigest md = MessageDigest.getInstance("MD5");
      return md.digest(input);
    } catch (Exception e) {
      throw new RuntimeException("Couldn't calculate MD5 for " + new String(input), e);
    }
  }
}
