/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.security;

import com.terracotta.management.security.SecretProviderBackEnd;
import java.io.Console;
import java.util.concurrent.atomic.AtomicReference;

public class SecretProvider {
    private static final AtomicReference<SecretProviderBackEnd> backEnd = new AtomicReference();
    public static final String CUSTOM_IMPL_PROP = "com.tc.SecretProvider.impl";

    public static byte[] getSecret() {
        return SecretProvider.getBackEnd().getSecret();
    }

    public static void fetchSecret() {
        SecretProviderBackEnd secretProviderBackEnd = backEnd.get();
        if (secretProviderBackEnd == null) {
            String implClass = System.getProperty(CUSTOM_IMPL_PROP);
            if (implClass != null) {
                try {
                    Class<?> clazz = Class.forName(implClass);
                    secretProviderBackEnd = (SecretProviderBackEnd)clazz.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Couldn't load class '" + implClass + "'", e);
                }
                catch (Exception e) {
                    throw new RuntimeException("Couldn't instantiate SecretProvider's backing implementation '" + implClass + "'", e);
                }
            } else {
                secretProviderBackEnd = new ConsoleFetchingBackEnd();
            }
            backEnd.compareAndSet(null, secretProviderBackEnd);
        }
        SecretProvider.getBackEnd().fetchSecret();
    }

    public static boolean fetchSecret(SecretProviderBackEnd back) {
        boolean installed = backEnd.compareAndSet(null, back);
        if (installed) {
            SecretProvider.getBackEnd().fetchSecret();
        }
        return installed;
    }

    static SecretProviderBackEnd getBackEnd() {
        return backEnd.get();
    }

    private static class ConsoleFetchingBackEnd
    implements SecretProviderBackEnd {
        private byte[] secret;

        private ConsoleFetchingBackEnd() {
        }

        @Override
        public byte[] getSecret() {
            return this.secret;
        }

        @Override
        public void fetchSecret() {
            byte[] byArray = this.secret = System.getProperty("SecretProvider.secret") == null ? null : ((String)System.getProperties().get("SecretProvider.secret")).getBytes();
            if (this.secret == null) {
                Console console = System.console();
                if (console == null) {
                    throw new RuntimeException("Couldn't access a Console instance to fetch the password from!");
                }
                this.secret = ConsoleFetchingBackEnd.toBytes(console.readPassword("Enter secret to key store: ", new Object[0]));
            }
        }

        private static byte[] toBytes(char[] chars) {
            byte[] bytes = new byte[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                bytes[i] = (byte)chars[i];
            }
            return bytes;
        }
    }
}

