/*
 * All content copyright (c) 2003-2012 Terracotta, Inc., except as may otherwise be noted in a separate copyright
 * notice. All rights reserved.
 */

package com.terracotta.management.security.shiro;

/**
 * An uninstantiable class for holding shiro ini file constants for this domain.
 *
 * @author brandony
 */
public final class ShiroIniFileConstants {
  /**
   * A constant for the default ini file location.
   */
  public static final String DFLT_INI_FILE_LOCATION = System.getProperty("user.home") + "/.tc/mgmt/security.ini";

  /**
   * A constant for the jvm ini file location property.
   */
  public static final String JVM_INI_LOCATION_PROP = "com.tc.management.security.ini";

  private ShiroIniFileConstants(){/**Cannot be instantiated**/}
}
