/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.management.user;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public enum UserRole {
    ADMIN("admin"),
    OPERATOR("operator"),
    TERRACOTTA("terracotta");

    private final String roleName;

    public static UserRole byName(String roleName) {
        UserRole returnVal = null;
        for (UserRole role : EnumSet.allOf(UserRole.class)) {
            if (!roleName.equals(role.toString())) continue;
            returnVal = role;
        }
        return returnVal;
    }

    public static Set<UserRole> convertRoleNames(Collection<String> roleNames) {
        HashSet<UserRole> roles = new HashSet<UserRole>(roleNames.size());
        for (String roleName : roleNames) {
            UserRole role = UserRole.byName(roleName);
            if (role == null) continue;
            roles.add(role);
        }
        return roles;
    }

    public static Set<String> convertRoles(Collection<UserRole> roles) {
        HashSet<String> roleNames = new HashSet<String>(roles.size());
        for (UserRole role : roles) {
            roleNames.add(role.toString());
        }
        return roleNames;
    }

    private UserRole(String roleName) {
        this.roleName = roleName;
    }

    public String toString() {
        return this.roleName;
    }
}

